<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SendMessageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'body' => 'required|string|max:1000',
            'attachment' => 'nullable|file|mimes:pdf,jpg,jpeg,png,docx|max:5120', // 5MB max
        ];
    }
    
    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'body.required' => 'A message body is required',
            'body.max' => 'Message body cannot exceed 1000 characters',
            'attachment.file' => 'The attachment must be a file',
            'attachment.mimes' => 'The attachment must be a file of type: pdf, jpg, jpeg, png, docx',
            'attachment.max' => 'The attachment cannot exceed 5MB',
        ];
    }
}