<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\ScheduledReel;

class ReelRateLimit
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();
        
        if (!$user) {
            return $next($request);
        }
        
        // Determine owner ID and type
        $ownerId = $user->hasRole('brand_admin') ? $user->brand_id : $user->id;
        $ownerType = $user->hasRole('brand_admin') ? 'App\Models\Brand' : 'App\Models\User';
        
        // Check daily limit
        $dailyLimit = config('reels.post_rate_limit_per_day', 10);
        $todayCount = ScheduledReel::where('owner_id', $ownerId)
            ->where('owner_type', $ownerType)
            ->whereDate('created_at', today())
            ->count();
            
        if ($todayCount >= $dailyLimit) {
            return redirect()->back()->with('error', 'You have reached your daily reel limit of ' . $dailyLimit . ' reels.');
        }
        
        // Check concurrent limit
        $concurrentLimit = config('reels.max_concurrent_per_owner', 3);
        $concurrentCount = ScheduledReel::where('owner_id', $ownerId)
            ->where('owner_type', $ownerType)
            ->whereIn('status', ['scheduled', 'queued', 'posting'])
            ->count();
            
        if ($concurrentCount >= $concurrentLimit) {
            return redirect()->back()->with('error', 'You have reached your concurrent reel limit of ' . $concurrentLimit . ' reels.');
        }
        
        return $next($request);
    }
}