<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class IdentifyTenant
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
        {
            $host = $request->getHost();
            $subdomain = explode('.', $host)[0];
    
            $tenant = \App\Models\Tenant::where('domain', $subdomain)->first();
    
            if ($tenant) {
                app()->singleton('currentTenant', function () use ($tenant) {
                    return $tenant;
                });
            }
    
            return $next($request);
        }
}
