<?php

namespace App\Http\Controllers\Creator;

use App\Http\Controllers\Controller;
use App\Models\Campaign;
use Illuminate\Http\Request;

class CampaignController extends Controller
{
    /**
     * Display a listing of campaigns
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $campaigns = Campaign::whereHas('creators', function ($query) {
            $query->where('creator_id', auth()->id());
        })->with('brand')
        ->orderBy('created_at', 'desc')
        ->paginate(20);
        
        return view('creator.campaigns.index', compact('campaigns'));
    }
    
    /**
     * Display the campaign invitations page
     *
     * @return \Illuminate\Http\Response
     */
    public function invitations()
    {
        // Get campaign invitations for this creator
        $invitations = \App\Models\CampaignCreator::where('creator_id', auth()->id())
            ->with('campaign.brand')
            ->paginate(20);
            
        return view('creator.campaigns.invitations', compact('invitations'));
    }
    
    /**
     * Display the specified campaign
     *
     * @param  \App\Models\Campaign  $campaign
     * @return \Illuminate\Http\Response
     */
    public function show(Campaign $campaign)
    {
        // Ensure the creator is part of this campaign
        if (!$campaign->creators()->where('creator_id', auth()->id())->exists()) {
            abort(403);
        }
        
        $campaign->load('brand', 'creators');
        
        // Get the creator's invitation status
        $invitation = $campaign->creators()->where('creator_id', auth()->id())->first();
        
        return view('creator.campaigns.show', compact('campaign', 'invitation'));
    }
}