<?php

namespace App\Http\Controllers\Brand;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\MarketplaceShortlist;
use Illuminate\Http\Request;

class MarketplaceController extends Controller
{
    /**
     * Display the marketplace index page
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // Get creators with their social aggregates
        $creators = User::whereHas('roles', function ($q) {
            $q->where('name', 'creator');
        })->with(['socialAggregates' => function ($q) {
            $q->whereIn('key', ['total_followers', 'total_posts']);
        }])->paginate(20);
        
        // Get all influencer types for filter dropdown
        $allTypes = [
            'Lifestyle', 'Tech', 'Gaming', 'Beauty', 'Fitness', 
            'Travel', 'Food', 'Education', 'Business', 
            'Entertainment', 'Sports', 'Other'
        ];
        
        return view('brand.marketplace.index', compact('creators', 'allTypes'));
    }
    
    /**
     * Display the shortlists page
     *
     * @return \Illuminate\Http\Response
     */
    public function shortlists()
    {
        $shortlists = MarketplaceShortlist::where('brand_id', auth()->user()->brand_id)
            ->with('creators')
            ->paginate(20);
            
        return view('brand.marketplace.shortlists', compact('shortlists'));
    }
    
    /**
     * Display the recommendations page
     *
     * @return \Illuminate\Http\Response
     */
    public function recommendations()
    {
        // Get recommended creators based on brand's social accounts
        $creators = User::whereHas('roles', function ($q) {
            $q->where('name', 'creator');
        })->with(['socialAggregates' => function ($q) {
            $q->whereIn('key', ['total_followers', 'total_posts', 'engagement_rate']);
        }])->orderBy('created_at', 'desc')
        ->limit(20)
        ->get();
        
        return view('brand.marketplace.recommendations', compact('creators'));
    }
}