<?php

namespace App\Http\Controllers\Brand;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ContentController extends Controller
{
    public function pending()
    {
        // Get pending content for the current brand
        $pendingContent = auth()->user()->brand->contents()->pending()->get();
        
        return view('brand.content.pending', compact('pendingContent'));
    }
    
    public function approve($id)
    {
        $content = \App\Models\Content::findOrFail($id);
        
        // Check if content belongs to the same brand
        if ($content->brand_id !== auth()->user()->brand_id) {
            return redirect()->back()->with('error', 'Unauthorized action.');
        }
        
        $content->update(['status' => 'published']);
        
        return redirect()->back()->with('success', 'Content approved successfully!');
    }
    
    public function reject($id)
    {
        $content = \App\Models\Content::findOrFail($id);
        
        // Check if content belongs to the same brand
        if ($content->brand_id !== auth()->user()->brand_id) {
            return redirect()->back()->with('error', 'Unauthorized action.');
        }
        
        $content->update(['status' => 'rejected']);
        
        return redirect()->back()->with('success', 'Content rejected successfully!');
    }
}
