<?php

namespace App\Http\Controllers\Agency;

use App\Http\Controllers\Controller;
use App\Models\Campaign;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    /**
     * Display the agency dashboard.
     */
    public function index()
    {
        // Get campaigns for the current agency
        $campaigns = Campaign::where('agency_id', Auth::id())->with('brand')->get();
        
        // Get brands linked to this agency
        $brands = Auth::user()->brands;
        
        // Calculate statistics
        $totalCampaigns = $campaigns->count();
        $activeCampaigns = $campaigns->where('status', 'active')->count();
        $totalBudget = $campaigns->sum('budget');
        $linkedBrands = $brands->count();
        
        // Get recent campaigns (limit to 5)
        $recentCampaigns = $campaigns->sortByDesc('created_at')->take(5);
        
        return view('agency.dashboard', compact(
            'totalCampaigns', 
            'activeCampaigns', 
            'totalBudget', 
            'linkedBrands', 
            'recentCampaigns'
        ));
    }
}