<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Jobs\DispatchDueScheduledPosts;

class ProcessScheduledPosts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'scheduled-posts:process';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process scheduled posts that are due for publishing';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Processing scheduled posts...');
        
        // Dispatch the job to process due scheduled posts
        DispatchDueScheduledPosts::dispatch();
        
        $this->info('Scheduled posts processing job dispatched successfully.');
    }
}
