# BrandAdmin सोशल कनेक्शन और डैशबोर्ड

## अवलोकन

यह पैकेज BrandAdmin उपयोगकर्ताओं के लिए मल्टी-प्लेटफॉर्म सोशल कनेक्शन और एकीकृत डैशबोर्ड कार्यक्षमता प्रदान करता है। BrandAdmin कंपनी YouTube, ब्रांड Instagram, Twitter/X, LinkedIn कंपनी पेज, TikTok ब्रांड खाता आदि के रूप में **ब्रांड-स्तरीय** सोशल खातों को कनेक्ट कर सकते हैं, ब्रांड के लिए एकत्रित KPI देख सकते हैं, प्रति-प्लेटफॉर्म विवरण देख सकते हैं, और सिंक ट्रिगर कर सकते हैं - सभी BrandAdmin पैनल (AdminLTE) से।

## सुविधाएँ

- **ब्रांड-स्तरीय सोशल खाते**: कंपनी/ब्रांड के सोशल मीडिया खातों को कनेक्ट करें
- **एकीकृत डैशबोर्ड**: KPI कार्ड, संयुक्त चार्ट, प्रदाता कार्ड और हाल के पोस्ट के साथ आकर्षक डैशबोर्ड
- **मैनुअल टोकन जोड़ें**: बिना OAuth के मैनुअल रूप से टोकन जोड़ें
- **डेमो मोड**: बिना वास्तविक API कुंजी के डेमो डेटा के साथ परीक्षण करें
- **रिपोर्ट और निर्यात**: CSV में डेटा निर्यात करें (वैकल्पिक)

## स्थापना

1. **माइग्रेशन चलाएँ**:
   ```bash
   php artisan migrate
   ```

2. **डेमो डेटा सीड करें**:
   ```bash
   php artisan db:seed --class=SocialDemoSeeder
   ```

## उपयोग

### ब्रांड एडमिन के रूप में लॉगिन करें

डेमो ब्रांड एडमिन क्रेडेंशियल का उपयोग करके लॉगिन करें:

- **ईमेल**: `brand@demo.local`
- **पासवर्ड**: `password123`

### ब्रांड डैशबोर्ड तक पहुँचें

लॉगिन करने के बाद, ब्रांड डैशबोर्ड पर जाएँ:
- URL: `/brand/dashboard`

### सोशल कनेक्शन प्रबंधित करें

ब्रांड के सोशल कनेक्शन प्रबंधित करें:
- URL: `/brand/connections`

### नए कनेक्शन जोड़ें

"कनेक्ट नया खाता" बटन पर क्लिक करें और एक प्लेटफॉर्म चुनें। यदि .env में API कुंजी हैं, तो OAuth प्रवाह शुरू हो जाएगा।

### मैनुअल टोकन जोड़ें

"मैनुअल टोकन जोड़ें" बटन पर क्लिक करें और आवश्यक जानकारी प्रदान करें:
- प्लेटफॉर्म
- खाता ID
- एक्सेस टोकन

### सिंक अब

"सिंक अब" बटन पर क्लिक करें ताकि `SyncBrandSocialAccounts` जॉब ट्रिगर हो सके और सोशल खातों को अपडेट किया जा सके।

## कमांड लाइन इंटरफेस (CLI)

### ब्रांड के लिए मैनुअल सिंक

किसी विशिष्ट ब्रांड के लिए सोशल खातों को मैनुअल रूप से सिंक करें:

```bash
php artisan social:sync --brand=1
```

## प्रदाता कॉन्फ़िगरेशन

### OAuth रीडायरेक्ट URIs

ब्रांड कनेक्शन के लिए प्रदाता कॉन्फ़िगरेशन में निम्नलिखित रीडायरेक्ट URIs जोड़ें:

- YouTube: `https://yourdomain.com/brand/connections/callback/youtube`
- Instagram: `https://yourdomain.com/brand/connections/callback/instagram`
- Twitter: `https://yourdomain.com/brand/connections/callback/twitter`
- LinkedIn: `https://yourdomain.com/brand/connections/callback/linkedin`
- TikTok: `https://yourdomain.com/brand/connections/callback/tiktok`

## रक्षात्मक प्रोग्रामिंग

### उपयोग किए गए पैटर्न

1. **गार्ड क्लॉज**: प्रत्येक नियंत्रक कार्य में शीर्ष पर जांच करें कि ब्रांड मौजूद है या नहीं
   ```php
   if (!$brand = auth()->user()->brand) {
       return redirect()->route('home')->with('error', 'Brand not found');
   }
   ```

2. **स्विच स्टेटमेंट**: कई प्रदाता प्रकारों को संभालने के लिए स्विच का उपयोग करें

3. **ट्राई/कैच ब्लॉक**: बाहरी API कॉल को लपेटें और त्रुटियों को `social_sync_errors` में लॉग करें

4. **शुरुआती रिटर्न**: अनुमति/अमान्य स्थितियों के लिए शुरुआती रिटर्न का उपयोग करें

5. **नल-सुरक्षित ब्लेड**: गतिशील डेटा के लिए नल-सुरक्षित ब्लेड का उपयोग करें
   ```blade
   {{ optional($aggregate)->value ?? 0 }}
   ```

## फ़ाइल संरचना

```
app/
├── Http/
│   └── Controllers/
│       └── Brand/
│           ├── SocialController.php
│           └── DashboardController.php
├── Jobs/
│   └── SyncBrandSocialAccounts.php
├── Console/
│   └── Commands/
│       └── SocialSyncCommand.php
├── Models/
│   ├── SocialAccount.php
│   ├── SocialAggregate.php
│   └── Brand.php
├── Policies/
│   └── SocialAccountPolicy.php
└── Services/
    └── SocialProviders/
        ├── ProviderFactory.php
        ├── ProviderInterface.php
        └── BaseProvider.php

database/
├── migrations/
│   ├── 2025_09_23_042608_add_brand_id_and_tenant_id_to_social_accounts_table.php
│   └── 2025_09_23_042713_add_brand_id_and_tenant_id_to_social_aggregates_table.php
└── seeders/
    └── SocialDemoSeeder.php

resources/
└── views/
    └── brand/
        ├── dashboard.blade.php
        ├── connections.blade.php
        └── provider/
            └── show.blade.php

routes/
└── web.php

tests/
└── Feature/
    └── BrandSocialConditionalTest.php
```

## परीक्षण

### शर्तबद्ध प्रवाह परीक्षण

`BrandSocialConditionalTest.php` में निम्नलिखित परीक्षण शामिल हैं:

- लापता टोकन के साथ कनेक्शन
- समाप्त टोकन ताज़ा करना
- अमान्य प्रदाता के साथ कनेक्शन
- अनधिकृत पहुँच का प्रयास

## समस्या निवारण

### सामान्य समस्याएँ

1. **OAuth कनेक्शन विफल**: सुनिश्चित करें कि .env में सही क्रेडेंशियल हैं और रीडायरेक्ट URIs सही कॉन्फ़िगर किए गए हैं

2. **टोकन समाप्ति**: "टोकन समाप्त" स्थिति देखें और खाते को पुनः कनेक्ट करें

3. **डेमो डेटा दिखाई नहीं दे रहा है**: सुनिश्चित करें कि आपने `SocialDemoSeeder` के साथ डेटाबेस को सीड किया है

### लॉग

- सिंक त्रुटियाँ: `storage/logs/laravel.log` में लॉग की जाती हैं
- सिंक त्रुटियाँ: `social_sync_errors` तालिका में भी संग्रहीत की जाती हैं

## योगदान

इस प्रोजेक्ट में योगदान करने के लिए:

1. रिपॉजिटरी फोर्क करें
2. एक फीचर ब्रांच बनाएँ (`git checkout -b feature/AmazingFeature`)
3. अपने परिवर्तन कमिट करें (`git commit -m 'Add some AmazingFeature'`)
4. ब्रांच को पुश करें (`git push origin feature/AmazingFeature`)
5. एक पुल रिक्वेस्ट खोलें

## लाइसेंस

यह प्रोजेक्ट MIT लाइसेंस के तहत लाइसेंस प्राप्त है - अधिक जानकारी के लिए [LICENSE](LICENSE) फ़ाइल देखें।

## समर्थन

किसी भी प्रश्न या समर्थन के लिए, कृपया एक मुद्दा खोलें या हमसे संपर्क करें।
