# Quick Start Guide - AI Microservice

## ✅ Installation Complete!

Sabhi required packages successfully install ho gaye hain.

## 🚀 Start Karne Ke Steps

### 1. Environment Setup

```bash
# .env file create karo
cp .env.example .env
```

`.env` file mein apne credentials add karo:
```bash
# Required
SECRET_KEY=your-secret-key-change-this
ENCRYPTION_KEY=your-32-byte-encryption-key-here
JWT_SECRET=your-jwt-secret-here
LARAVEL_API_KEY=your-laravel-api-key
LARAVEL_CALLBACK_SECRET=shared-secret-for-callbacks

# AI Providers (at least one required)
OPENAI_API_KEY=sk-your-openai-key
# OR
ANTHROPIC_API_KEY=sk-ant-your-anthropic-key
```

### 2. Database Setup

PostgreSQL install karo ya Docker use karo:

```bash
# Docker se PostgreSQL start karo
docker run -d \
  --name ai-postgres \
  -e POSTGRES_USER=ai_user \
  -e POSTGRES_PASSWORD=ai_password \
  -e POSTGRES_DB=ai_microservice \
  -p 5432:5432 \
  postgres:15-alpine
```

### 3. Redis Setup

```bash
# Docker se Redis start karo
docker run -d \
  --name ai-redis \
  -p 6379:6379 \
  redis:7-alpine
```

### 4. Service Start Karo

**Terminal 1 - FastAPI Server:**
```bash
python -m uvicorn app.main:app --reload --host 0.0.0.0 --port 8000
```

**Terminal 2 - Celery Worker:**
```bash
celery -A app.celery_app worker --loglevel=info --concurrency=4
```

**Terminal 3 - Celery Beat (Optional - for scheduled tasks):**
```bash
celery -A app.celery_app beat --loglevel=info
```

### 5. Test Karo

API docs open karo: http://localhost:8000/docs

Ya curl se test karo:
```bash
curl http://localhost:8000/health
```

## 🐳 Docker Se Start Karo (Recommended)

Sabse easy way:

```bash
# Sab services ek saath start karo
docker-compose up -d

# Logs dekho
docker-compose logs -f

# Stop karo
docker-compose down
```

Services available hongi:
- API: http://localhost:8000
- API Docs: http://localhost:8000/docs
- Flower (Celery Monitor): http://localhost:5555

## 📝 First API Call

```bash
curl -X POST http://localhost:8000/v1/ai/jobs \
  -H "Content-Type: application/json" \
  -H "X-API-Key: your-laravel-api-key" \
  -d '{
    "job_type": "content_ideas",
    "tenant_id": "test-tenant",
    "owner_id": "test-user",
    "payload": {
      "topic": "AI in marketing",
      "count": 5,
      "tone": "professional"
    }
  }'
```

Response:
```json
{
  "ai_job_id": "job-123-456",
  "status": "pending",
  "estimated_time_seconds": 30,
  "message": "Job queued successfully"
}
```

## 🔍 Job Status Check Karo

```bash
curl http://localhost:8000/v1/ai/jobs/{job_id} \
  -H "X-API-Key: your-laravel-api-key"
```

## ⚙️ Test Mode

Testing ke liye mock providers use karo:

`.env` mein:
```bash
TEST_MODE=true
MOCK_PROVIDERS=true
```

Isse real API calls nahi hongi, mock responses milenge.

## 📊 Monitoring

- Health Check: http://localhost:8000/health
- Metrics: http://localhost:8000/metrics
- Admin Metrics: http://localhost:8000/admin/metrics (requires admin key)

## 🐛 Troubleshooting

### Database connection error
```bash
# Check PostgreSQL running hai
docker ps | grep postgres

# Logs check karo
docker logs ai-postgres
```

### Redis connection error
```bash
# Check Redis running hai
docker ps | grep redis

# Test connection
redis-cli ping
```

### Celery worker not starting
```bash
# Redis check karo
redis-cli ping

# Worker logs dekho
celery -A app.celery_app worker --loglevel=debug
```

## 📚 Next Steps

1. [README.md](README.md) - Complete documentation
2. [ARCHITECTURE.md](ARCHITECTURE.md) - System architecture
3. API Docs: http://localhost:8000/docs

## 🎯 Available Job Types

- `proposal` - Business proposals generate karo
- `content_ideas` - Content ideas generate karo
- `auto_reply` - Auto-replies generate karo
- `ads_generate` - Ad variants generate karo
- `forecast` - Forecasting/predictions
- `matchmaking` - Influencer-brand matching
- `translate` - Content translation
- `contract_draft` - Contract drafts
- `support_rag` - Support queries (RAG-based)
- `custom` - Custom prompts

## 🌐 Social Media Publishing

Supported platforms:
- Twitter/X
- Facebook
- Instagram
- LinkedIn

Example:
```bash
curl -X POST http://localhost:8000/v1/publish \
  -H "Content-Type: application/json" \
  -H "X-API-Key: your-key" \
  -d '{
    "platform": "twitter",
    "tenant_id": "brand-123",
    "owner_id": "user-456",
    "content": {
      "text": "Hello from AI Microservice!"
    }
  }'
```

Happy Coding! 🚀