<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class AccessControlTest extends TestCase
{
    use RefreshDatabase;

    protected $brandAdmin;
    protected $creator;
    protected $regularUser;

    protected function setUp(): void
    {
        parent::setUp();

        // Create a brand
        $brand = \App\Models\Brand::factory()->create([
            'name' => 'Test Brand',
        ]);

        // Create users with different roles
        $this->brandAdmin = User::factory()->create([
            'name' => 'Brand Admin',
            'email' => 'brand@example.com',
            'brand_id' => $brand->id,
        ]);
        $this->brandAdmin->assignRole('brand_admin');

        $this->creator = User::factory()->create([
            'name' => 'Test Creator',
            'email' => 'creator@example.com',
        ]);
        $this->creator->assignRole('creator');

        $this->regularUser = User::factory()->create([
            'name' => 'Regular User',
            'email' => 'user@example.com',
        ]);
        $this->regularUser->assignRole('user');
    }

    /** @test */
    public function brand_routes_are_inaccessible_to_non_brand_users()
    {
        // Test with creator user
        $response = $this->actingAs($this->creator)
            ->get(route('brand.creators.index'));

        $response->assertStatus(403);

        // Test with regular user
        $response = $this->actingAs($this->regularUser)
            ->get(route('brand.creators.index'));

        $response->assertStatus(403);
    }

    /** @test */
    public function brand_proposal_routes_are_inaccessible_to_non_brand_users()
    {
        // Test with creator user
        $response = $this->actingAs($this->creator)
            ->get(route('brand.creators.proposal.create', $this->creator));

        $response->assertStatus(403);

        // Test with regular user
        $response = $this->actingAs($this->regularUser)
            ->get(route('brand.creators.proposal.create', $this->creator));

        $response->assertStatus(403);
    }

    /** @test */
    public function brand_routes_are_accessible_to_brand_admins()
    {
        $response = $this->actingAs($this->brandAdmin)
            ->get(route('brand.creators.index'));

        $response->assertStatus(200);
    }
}