<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['selectedRole' => 'brand']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['selectedRole' => 'brand']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<section class="relative bg-gradient-to-br from-blue-50 via-indigo-50 to-purple-50 overflow-hidden">
    <!-- Background Pattern -->
    <div class="absolute inset-0 bg-grid-pattern opacity-5"></div>
    
    <!-- Animated Background Elements -->
    <div class="absolute top-20 left-10 w-72 h-72 bg-blue-400 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-float"></div>
    <div class="absolute top-40 right-10 w-72 h-72 bg-purple-400 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-float" style="animation-delay: 2s;"></div>
    <div class="absolute -bottom-8 left-1/2 w-72 h-72 bg-pink-400 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-float" style="animation-delay: 4s;"></div>

    <!-- Content -->
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20 lg:py-32">
        <div class="grid lg:grid-cols-2 gap-12 items-center">
            <!-- Left Column: Copy & CTAs -->
            <div class="text-center lg:text-left" x-data="{ selectedRole: '<?php echo e($selectedRole); ?>' }">
                <!-- Role Selector Pills -->
                <div class="inline-flex items-center space-x-2 bg-white rounded-full p-1 shadow-lg mb-6">
                    <button @click="selectedRole = 'brand'" 
                            :class="selectedRole === 'brand' ? 'bg-blue-600 text-white' : 'text-gray-600 hover:text-gray-900'"
                            class="px-4 py-2 rounded-full text-sm font-semibold transition-all duration-200">
                        Brand
                    </button>
                    <button @click="selectedRole = 'creator'" 
                            :class="selectedRole === 'creator' ? 'bg-blue-600 text-white' : 'text-gray-600 hover:text-gray-900'"
                            class="px-4 py-2 rounded-full text-sm font-semibold transition-all duration-200">
                        Creator
                    </button>
                    <button @click="selectedRole = 'agency'" 
                            :class="selectedRole === 'agency' ? 'bg-blue-600 text-white' : 'text-gray-600 hover:text-gray-900'"
                            class="px-4 py-2 rounded-full text-sm font-semibold transition-all duration-200">
                        Agency
                    </button>
                </div>

                <!-- Dynamic Headlines -->
                <div x-show="selectedRole === 'brand'" x-cloak>
                    <h1 class="text-4xl sm:text-5xl lg:text-6xl font-bold text-gray-900 mb-6 leading-tight">
                        Turn Creators Into <span class="gradient-text">Customers</span>
                    </h1>
                    <p class="text-xl text-gray-600 mb-8 leading-relaxed">
                        Manage campaigns, content & ads with AI. <strong>Save 10+ hours/week.</strong> Increase engagement by <strong>20%.</strong>
                    </p>
                </div>

                <div x-show="selectedRole === 'creator'" x-cloak>
                    <h1 class="text-4xl sm:text-5xl lg:text-6xl font-bold text-gray-900 mb-6 leading-tight">
                        Grow Your <span class="gradient-text">Creator Business</span>
                    </h1>
                    <p class="text-xl text-gray-600 mb-8 leading-relaxed">
                        Get AI-powered content ideas, auto-replies, and campaign tools. <strong>Post 3x faster.</strong> Earn <strong>40% more.</strong>
                    </p>
                </div>

                <div x-show="selectedRole === 'agency'" x-cloak>
                    <h1 class="text-4xl sm:text-5xl lg:text-6xl font-bold text-gray-900 mb-6 leading-tight">
                        Scale Your <span class="gradient-text">Agency</span> Operations
                    </h1>
                    <p class="text-xl text-gray-600 mb-8 leading-relaxed">
                        Manage multiple brands, creators & campaigns from one dashboard. <strong>Handle 5x more clients.</strong> White-label ready.
                    </p>
                </div>

                <!-- CTAs -->
                <div class="flex flex-col sm:flex-row gap-4 justify-center lg:justify-start mb-8">
                    <a href="<?php echo e(route('register')); ?>" 
                       onclick="gtag('event', 'click', {'event_category': 'CTA', 'event_label': 'Hero Primary CTA'});"
                       class="inline-flex items-center justify-center px-8 py-4 bg-blue-600 text-white text-lg font-semibold rounded-lg hover:bg-blue-700 transform hover:scale-105 transition-all duration-200 shadow-lg hover:shadow-xl">
                        <span x-show="selectedRole === 'brand'">Start Free Trial</span>
                        <span x-show="selectedRole === 'creator'" x-cloak>Get Started Free</span>
                        <span x-show="selectedRole === 'agency'" x-cloak>Book Demo</span>
                        <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
                        </svg>
                    </a>
                    <a href="<?php echo e(route('marketing.pricing')); ?>" 
                       class="inline-flex items-center justify-center px-8 py-4 bg-white text-gray-900 text-lg font-semibold rounded-lg hover:bg-gray-50 border-2 border-gray-200 transition-all duration-200">
                        View Pricing
                    </a>
                </div>

                <!-- Trust Strip -->
                <div class="flex flex-col sm:flex-row items-center justify-center lg:justify-start gap-6 text-sm text-gray-500">
                    <div class="flex items-center gap-2">
                        <svg class="w-5 h-5 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span class="font-medium">No credit card required</span>
                    </div>
                    <div class="flex items-center gap-2">
                        <svg class="w-5 h-5 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span class="font-medium">14-day free trial</span>
                    </div>
                    <div class="flex items-center gap-2">
                        <svg class="w-5 h-5 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span class="font-medium">Cancel anytime</span>
                    </div>
                </div>

                <!-- Social Proof Numbers -->
                <div class="grid grid-cols-3 gap-6 mt-12 pt-12 border-t border-gray-200">
                    <div class="text-center">
                        <div class="text-3xl font-bold text-gray-900">500+</div>
                        <div class="text-sm text-gray-600 mt-1">Active Brands</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl font-bold text-gray-900">2K+</div>
                        <div class="text-sm text-gray-600 mt-1">Creators</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl font-bold text-gray-900">10K+</div>
                        <div class="text-sm text-gray-600 mt-1">Campaigns</div>
                    </div>
                </div>
            </div>

            <!-- Right Column: Visual -->
            <div class="relative">
                <!-- Product Mockup -->
                <div class="relative rounded-2xl shadow-2xl overflow-hidden bg-white">
                    <!-- Browser Chrome -->
                    <div class="bg-gray-100 px-4 py-3 flex items-center space-x-2 border-b border-gray-200">
                        <div class="flex space-x-2">
                            <div class="w-3 h-3 rounded-full bg-red-500"></div>
                            <div class="w-3 h-3 rounded-full bg-yellow-500"></div>
                            <div class="w-3 h-3 rounded-full bg-green-500"></div>
                        </div>
                        <div class="flex-1 bg-white rounded px-3 py-1 text-xs text-gray-500">
                            aibusinessmarket.com/dashboard
                        </div>
                    </div>
                    
                    <!-- Dashboard Screenshot Placeholder -->
                    <div class="bg-gradient-to-br from-blue-50 to-indigo-100 p-8">
                        <div class="space-y-4">
                            <!-- Stats Cards -->
                            <div class="grid grid-cols-3 gap-4">
                                <div class="bg-white rounded-lg p-4 shadow">
                                    <div class="text-xs text-gray-500 mb-1">Campaigns</div>
                                    <div class="text-2xl font-bold text-gray-900">24</div>
                                    <div class="text-xs text-green-600 mt-1">↑ 12%</div>
                                </div>
                                <div class="bg-white rounded-lg p-4 shadow">
                                    <div class="text-xs text-gray-500 mb-1">Engagement</div>
                                    <div class="text-2xl font-bold text-gray-900">89%</div>
                                    <div class="text-xs text-green-600 mt-1">↑ 8%</div>
                                </div>
                                <div class="bg-white rounded-lg p-4 shadow">
                                    <div class="text-xs text-gray-500 mb-1">ROI</div>
                                    <div class="text-2xl font-bold text-gray-900">3.2x</div>
                                    <div class="text-xs text-green-600 mt-1">↑ 15%</div>
                                </div>
                            </div>
                            
                            <!-- Chart Placeholder -->
                            <div class="bg-white rounded-lg p-6 shadow">
                                <div class="flex items-center justify-between mb-4">
                                    <div class="text-sm font-semibold text-gray-900">Campaign Performance</div>
                                    <div class="text-xs text-gray-500">Last 30 days</div>
                                </div>
                                <div class="h-32 bg-gradient-to-t from-blue-100 to-transparent rounded"></div>
                            </div>
                            
                            <!-- Activity List -->
                            <div class="bg-white rounded-lg p-4 shadow space-y-3">
                                <div class="flex items-center space-x-3">
                                    <div class="w-8 h-8 rounded-full bg-blue-100"></div>
                                    <div class="flex-1">
                                        <div class="text-xs font-medium text-gray-900">New proposal generated</div>
                                        <div class="text-xs text-gray-500">2 minutes ago</div>
                                    </div>
                                </div>
                                <div class="flex items-center space-x-3">
                                    <div class="w-8 h-8 rounded-full bg-green-100"></div>
                                    <div class="flex-1">
                                        <div class="text-xs font-medium text-gray-900">Campaign approved</div>
                                        <div class="text-xs text-gray-500">1 hour ago</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Floating Elements -->
                <div class="absolute -top-6 -right-6 bg-white rounded-lg shadow-xl p-4 animate-float">
                    <div class="flex items-center space-x-2">
                        <div class="w-10 h-10 rounded-full bg-green-100 flex items-center justify-center">
                            <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                        </div>
                        <div>
                            <div class="text-xs font-semibold text-gray-900">AI Generated</div>
                            <div class="text-xs text-gray-500">Content ready</div>
                        </div>
                    </div>
                </div>

                <div class="absolute -bottom-6 -left-6 bg-white rounded-lg shadow-xl p-4 animate-float" style="animation-delay: 1s;">
                    <div class="flex items-center space-x-2">
                        <div class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                            </svg>
                        </div>
                        <div>
                            <div class="text-xs font-semibold text-gray-900">10x Faster</div>
                            <div class="text-xs text-gray-500">With AI automation</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Customer Logos -->
        <div class="mt-20 pt-12 border-t border-gray-200">
            <p class="text-center text-sm text-gray-500 mb-8">Trusted by leading brands and creators</p>
            <div class="flex flex-wrap justify-center items-center gap-8 opacity-50 grayscale">
                <!-- Placeholder logos - replace with actual customer logos -->
                <div class="text-2xl font-bold text-gray-400">BRAND 1</div>
                <div class="text-2xl font-bold text-gray-400">BRAND 2</div>
                <div class="text-2xl font-bold text-gray-400">BRAND 3</div>
                <div class="text-2xl font-bold text-gray-400">BRAND 4</div>
                <div class="text-2xl font-bold text-gray-400">BRAND 5</div>
            </div>
        </div>
    </div>
</section><?php /**PATH C:\xampp\htdocs\AI business market\Laravel\resources\views/components/marketing/hero.blade.php ENDPATH**/ ?>