<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Brand\ReelController as BrandReelController;
use App\Http\Controllers\Creator\ReelController as CreatorReelController;

// Brand reels routes
Route::prefix('brand')->middleware(['auth', 'role:brand_admin|superadmin', 'IdentifyTenant'])->group(function () {
    Route::get('/reels', [BrandReelController::class, 'index'])->name('brand.reels.index');
    Route::get('/reels/create', [BrandReelController::class, 'create'])->name('brand.reels.create');
    Route::post('/reels', [BrandReelController::class, 'store'])->name('brand.reels.store');
    Route::get('/reels/{reel}', [BrandReelController::class, 'show'])->name('brand.reels.show');
    Route::post('/reels/{reel}/post-now', [BrandReelController::class, 'postNow'])->name('brand.reels.post-now');
    Route::post('/reels/{reel}/reschedule', [BrandReelController::class, 'reschedule'])->name('brand.reels.reschedule');
    Route::post('/reels/{reel}/cancel', [BrandReelController::class, 'cancel'])->name('brand.reels.cancel');
    
    // Scheduled reels routes
    Route::get('/reels/scheduled/create', [BrandReelController::class, 'createScheduled'])->name('brand.reels.scheduled.create');
    Route::post('/reels/scheduled', [BrandReelController::class, 'storeScheduled'])->name('brand.reels.scheduled.store')->middleware('reel.rate.limit');
    Route::get('/reels/scheduled/{reel}', [BrandReelController::class, 'showScheduled'])->name('brand.reels.scheduled.show');
    Route::post('/reels/scheduled/{reel}/post-now', [BrandReelController::class, 'postNow'])->name('brand.reels.scheduled.post-now');
    Route::post('/reels/scheduled/{reel}/reschedule', [BrandReelController::class, 'reschedule'])->name('brand.reels.scheduled.reschedule');
    Route::post('/reels/scheduled/{reel}/cancel', [BrandReelController::class, 'cancel'])->name('brand.reels.scheduled.cancel');
});

// Creator reels routes
Route::prefix('creator')->middleware(['auth', 'role:creator', 'IdentifyTenant'])->group(function () {
    Route::get('/reels', [CreatorReelController::class, 'index'])->name('creator.reels.index');
    Route::get('/reels/create', [CreatorReelController::class, 'create'])->name('creator.reels.create');
    Route::post('/reels', [CreatorReelController::class, 'store'])->name('creator.reels.store');
    Route::get('/reels/{reel}', [CreatorReelController::class, 'show'])->name('creator.reels.show');
    Route::post('/reels/{reel}/post-now', [CreatorReelController::class, 'postNow'])->name('creator.reels.post-now');
    Route::post('/reels/{reel}/reschedule', [CreatorReelController::class, 'reschedule'])->name('creator.reels.reschedule');
    Route::post('/reels/{reel}/cancel', [CreatorReelController::class, 'cancel'])->name('creator.reels.cancel');
    
    // Scheduled reels routes
    Route::get('/reels/scheduled/create', [CreatorReelController::class, 'createScheduled'])->name('creator.reels.scheduled.create');
    Route::post('/reels/scheduled', [CreatorReelController::class, 'storeScheduled'])->name('creator.reels.scheduled.store')->middleware('reel.rate.limit');
    Route::get('/reels/scheduled/{reel}', [CreatorReelController::class, 'showScheduled'])->name('creator.reels.scheduled.show');
    Route::post('/reels/scheduled/{reel}/post-now', [CreatorReelController::class, 'postNow'])->name('creator.reels.scheduled.post-now');
    Route::post('/reels/scheduled/{reel}/reschedule', [CreatorReelController::class, 'reschedule'])->name('creator.reels.scheduled.reschedule');
    Route::post('/reels/scheduled/{reel}/cancel', [CreatorReelController::class, 'cancel'])->name('creator.reels.scheduled.cancel');
});

// API callback route
Route::post('/api/reels/callback', [App\Http\Controllers\Api\ReelController::class, 'callback'])->name('api.reels.callback');