@extends('layouts.superadmin')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0">Subscription Plans</h1>
        <a href="{{ route('superadmin.plans.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Create New Plan
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        @foreach($plans as $plan)
            <div class="col-md-6 col-lg-3 mb-4">
                <div class="card h-100 {{ !$plan->is_active ? 'opacity-75' : '' }}">
                    <div class="card-header bg-{{ $plan->slug === 'starter' ? 'secondary' : ($plan->slug === 'pro' ? 'primary' : ($plan->slug === 'business' ? 'purple' : 'warning')) }} text-white">
                        <h5 class="card-title mb-0">{{ $plan->name }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <h3 class="display-6">{{ $plan->formatted_price }}</h3>
                            @if(!$plan->isFree() && $plan->slug !== 'enterprise')
                                <small class="text-muted">/{{ $plan->interval }}</small>
                            @endif
                        </div>

                        <p class="text-muted small mb-3">{{ $plan->description }}</p>

                        <div class="mb-3">
                            <span class="badge bg-{{ $plan->is_active ? 'success' : 'secondary' }}">
                                {{ $plan->is_active ? 'Active' : 'Inactive' }}
                            </span>
                            <span class="badge bg-info">{{ $plan->type }}</span>
                            @if($plan->hasTrial())
                                <span class="badge bg-primary">{{ $plan->trial_days }}d trial</span>
                            @endif
                        </div>

                        <div class="small text-muted mb-3">
                            <div><strong>Subscriptions:</strong> {{ $plan->subscriptions()->count() }}</div>
                            <div><strong>Active:</strong> {{ $plan->subscriptions()->active()->count() }}</div>
                        </div>

                        <div class="d-grid gap-2">
                            <a href="{{ route('superadmin.plans.show', $plan) }}" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-eye"></i> View Details
                            </a>
                            <a href="{{ route('superadmin.plans.edit', $plan) }}" class="btn btn-sm btn-outline-secondary">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                            <form action="{{ route('superadmin.plans.toggle-status', $plan) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-sm btn-outline-{{ $plan->is_active ? 'warning' : 'success' }} w-100">
                                    <i class="fas fa-{{ $plan->is_active ? 'pause' : 'play' }}"></i> 
                                    {{ $plan->is_active ? 'Deactivate' : 'Activate' }}
                                </button>
                            </form>
                            @if($plan->subscriptions()->active()->count() === 0)
                                <form action="{{ route('superadmin.plans.destroy', $plan) }}" method="POST" 
                                      onsubmit="return confirm('Are you sure you want to delete this plan?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger w-100">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>
                                </form>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>
@endsection