@extends('layouts.marketing')

@section('title', 'Payment Successful - AI Business Market')
@section('description', 'Thank you for subscribing to AI Business Market. Your account is now active.')

@push('structured-data')
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "Order",
    "orderNumber": "{{ $subscription->id ?? 'N/A' }}",
    "orderStatus": "https://schema.org/OrderProcessing",
    "orderDate": "{{ now()->toIso8601String() }}",
    "customer": {
        "@type": "Person",
        "name": "{{ auth()->user()->name }}"
    }
}
</script>
@endpush

@section('content')
<div class="min-h-screen bg-gradient-to-br from-blue-50 via-indigo-50 to-purple-50 py-20">
    <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
        
        <!-- Success Card -->
        <div class="bg-white rounded-2xl shadow-2xl overflow-hidden">
            <!-- Success Header -->
            <div class="bg-gradient-to-r from-green-500 to-emerald-600 px-8 py-12 text-center">
                <div class="w-20 h-20 bg-white rounded-full flex items-center justify-center mx-auto mb-6 animate-bounce">
                    <svg class="w-12 h-12 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                </div>
                <h1 class="text-4xl font-bold text-white mb-4">
                    Payment Successful!
                </h1>
                <p class="text-xl text-white opacity-90">
                    Welcome to AI Business Market
                </p>
            </div>

            <!-- Content -->
            <div class="px-8 py-10">
                <!-- Order Details -->
                @if(isset($subscription) && isset($plan))
                <div class="bg-gray-50 rounded-xl p-6 mb-8">
                    <h2 class="text-lg font-semibold text-gray-900 mb-4">Order Summary</h2>
                    <div class="space-y-3">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Plan:</span>
                            <span class="font-semibold text-gray-900">{{ $plan->name }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Amount Paid:</span>
                            <span class="font-semibold text-gray-900">{{ $plan->formatted_price }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Billing Cycle:</span>
                            <span class="font-semibold text-gray-900">{{ ucfirst($plan->interval) }}</span>
                        </div>
                        @if($subscription->onTrial())
                        <div class="flex justify-between">
                            <span class="text-gray-600">Trial Ends:</span>
                            <span class="font-semibold text-green-600">{{ $subscription->trial_ends_at->format('M d, Y') }}</span>
                        </div>
                        @endif
                        <div class="flex justify-between">
                            <span class="text-gray-600">Next Billing Date:</span>
                            <span class="font-semibold text-gray-900">{{ $subscription->current_period_end->format('M d, Y') }}</span>
                        </div>
                        @if(isset($paymentId))
                        <div class="flex justify-between">
                            <span class="text-gray-600">Transaction ID:</span>
                            <span class="font-mono text-sm text-gray-900">{{ $paymentId }}</span>
                        </div>
                        @endif
                    </div>
                </div>
                @endif

                <!-- What's Next -->
                <div class="mb-8">
                    <h2 class="text-2xl font-bold text-gray-900 mb-6">What's Next?</h2>
                    <div class="space-y-4">
                        <div class="flex items-start">
                            <div class="flex-shrink-0 w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center mr-4">
                                <span class="text-blue-600 font-bold">1</span>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-1">Check Your Email</h3>
                                <p class="text-gray-600">We've sent a confirmation email with your receipt and account details.</p>
                            </div>
                        </div>

                        <div class="flex items-start">
                            <div class="flex-shrink-0 w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center mr-4">
                                <span class="text-blue-600 font-bold">2</span>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-1">Complete Your Profile</h3>
                                <p class="text-gray-600">Set up your account and connect your social media profiles.</p>
                            </div>
                        </div>

                        <div class="flex items-start">
                            <div class="flex-shrink-0 w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center mr-4">
                                <span class="text-blue-600 font-bold">3</span>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-1">Start Creating</h3>
                                <p class="text-gray-600">Launch your first campaign and start working with creators.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="grid md:grid-cols-2 gap-4 mb-8">
                    <a href="{{ route('dashboard') }}" 
                       class="flex items-center justify-center px-6 py-4 bg-blue-600 text-white font-semibold rounded-lg hover:bg-blue-700 transition duration-200">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                        </svg>
                        Go to Dashboard
                    </a>

                    <a href="{{ route('subscription.manage') }}" 
                       class="flex items-center justify-center px-6 py-4 bg-white border-2 border-gray-300 text-gray-800 font-semibold rounded-lg hover:bg-gray-50 transition duration-200">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        View Invoice
                    </a>
                </div>

                <!-- Help Section -->
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-6">
                    <div class="flex items-start">
                        <div class="flex-shrink-0">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm font-semibold text-gray-900 mb-1">Need Help Getting Started?</h3>
                            <p class="text-sm text-gray-600 mb-3">
                                Check out our quick start guide or contact our support team.
                            </p>
                            <div class="flex flex-wrap gap-3">
                                <a href="{{ route('marketing.help') }}" class="text-sm text-blue-600 hover:text-blue-700 font-medium">
                                    View Help Center →
                                </a>
                                <a href="{{ route('marketing.demo') }}" class="text-sm text-blue-600 hover:text-blue-700 font-medium">
                                    Watch Demo →
                                </a>
                                <a href="mailto:support@aibusinessmarket.com" class="text-sm text-blue-600 hover:text-blue-700 font-medium">
                                    Contact Support →
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Footer -->
            <div class="bg-gray-50 px-8 py-6 border-t border-gray-200">
                <p class="text-center text-sm text-gray-600">
                    Questions about your subscription? 
                    <a href="{{ route('subscription.manage') }}" class="text-blue-600 hover:text-blue-700 font-medium">Manage your subscription</a> 
                    or <a href="mailto:billing@aibusinessmarket.com" class="text-blue-600 hover:text-blue-700 font-medium">contact billing support</a>
                </p>
            </div>
        </div>

        <!-- Social Proof -->
        <div class="mt-12 text-center">
            <p class="text-gray-600 mb-4">Join 500+ brands and 2,000+ creators already using AI Business Market</p>
            <div class="flex justify-center items-center space-x-8 opacity-50 grayscale">
                <div class="text-lg font-bold text-gray-400">BRAND 1</div>
                <div class="text-lg font-bold text-gray-400">BRAND 2</div>
                <div class="text-lg font-bold text-gray-400">BRAND 3</div>
            </div>
        </div>
    </div>
</div>

<!-- Fire analytics event -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        if (typeof window.tracker !== 'undefined') {
            window.tracker.paymentSuccess(
                '{{ $plan->id ?? '' }}',
                {{ $plan->price ?? 0 }},
                '{{ $paymentId ?? '' }}',
                '{{ auth()->id() }}'
            );
        }
    });
</script>
@endsection