<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice {{ $invoice->invoice_number }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 14px;
            color: #333;
        }
        .header {
            margin-bottom: 30px;
            border-bottom: 2px solid #3B82F6;
            padding-bottom: 20px;
        }
        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #1F2937;
        }
        .invoice-title {
            font-size: 18px;
            color: #6B7280;
            margin-top: 5px;
        }
        .details-section {
            margin-bottom: 30px;
        }
        .details-grid {
            display: table;
            width: 100%;
        }
        .details-col {
            display: table-cell;
            width: 50%;
            vertical-align: top;
        }
        .label {
            color: #6B7280;
            font-size: 12px;
            margin-bottom: 5px;
        }
        .value {
            font-weight: bold;
            margin-bottom: 15px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        th {
            background-color: #F3F4F6;
            padding: 12px;
            text-align: left;
            font-size: 12px;
            color: #6B7280;
            text-transform: uppercase;
        }
        td {
            padding: 12px;
            border-bottom: 1px solid #E5E7EB;
        }
        .text-right {
            text-align: right;
        }
        .totals {
            width: 300px;
            margin-left: auto;
        }
        .totals-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
        }
        .totals-row.total {
            border-top: 2px solid #3B82F6;
            font-size: 18px;
            font-weight: bold;
            color: #3B82F6;
            padding-top: 12px;
            margin-top: 8px;
        }
        .status-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: bold;
        }
        .status-paid {
            background-color: #D1FAE5;
            color: #065F46;
        }
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #E5E7EB;
            text-align: center;
            font-size: 12px;
            color: #6B7280;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <div class="company-name">{{ config('app.name') }}</div>
        <div class="invoice-title">INVOICE</div>
    </div>

    <!-- Invoice Info -->
    <div class="details-section">
        <div class="details-grid">
            <div class="details-col">
                <div class="label">Invoice Number</div>
                <div class="value">{{ $invoice->invoice_number }}</div>
                
                <div class="label">Issue Date</div>
                <div class="value">{{ $invoice->issued_at->format('F d, Y') }}</div>
                
                @if($invoice->paid_at)
                    <div class="label">Paid Date</div>
                    <div class="value">{{ $invoice->paid_at->format('F d, Y') }}</div>
                @endif
            </div>
            <div class="details-col">
                <div class="label">Bill To</div>
                <div class="value">
                    {{ $user->name }}<br>
                    {{ $user->email }}
                </div>
                
                <div class="label">Status</div>
                <div class="value">
                    <span class="status-badge status-{{ $invoice->status }}">
                        {{ strtoupper($invoice->status) }}
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Line Items -->
    <table>
        <thead>
            <tr>
                <th>Description</th>
                <th class="text-right">Quantity</th>
                <th class="text-right">Unit Price</th>
                <th class="text-right">Amount</th>
            </tr>
        </thead>
        <tbody>
            @foreach($invoice->line_items as $item)
                <tr>
                    <td>{{ $item['description'] }}</td>
                    <td class="text-right">{{ $item['quantity'] }}</td>
                    <td class="text-right">{{ $invoice->currency === 'INR' ? '₹' : '$' }}{{ number_format($item['unit_price'], 2) }}</td>
                    <td class="text-right">{{ $invoice->currency === 'INR' ? '₹' : '$' }}{{ number_format($item['amount'], 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <!-- Totals -->
    <div class="totals">
        <div class="totals-row">
            <span>Subtotal:</span>
            <span>{{ $invoice->formatted_subtotal }}</span>
        </div>
        @if($invoice->tax > 0)
            <div class="totals-row">
                <span>Tax:</span>
                <span>{{ $invoice->formatted_tax }}</span>
            </div>
        @endif
        <div class="totals-row total">
            <span>Total:</span>
            <span>{{ $invoice->formatted_total }}</span>
        </div>
    </div>

    <!-- Payment Info -->
    @if($invoice->transaction)
        <div style="margin-top: 30px; background-color: #F3F4F6; padding: 15px; border-radius: 8px;">
            <div style="font-weight: bold; margin-bottom: 10px;">Payment Information</div>
            <div style="font-size: 12px; color: #6B7280;">
                <div>Payment ID: {{ $invoice->transaction->razorpay_payment_id }}</div>
                <div>Payment Date: {{ $invoice->paid_at->format('F d, Y H:i') }}</div>
            </div>
        </div>
    @endif

    <!-- Footer -->
    <div class="footer">
        <p>Thank you for your business!</p>
        <p>This is a computer-generated invoice and does not require a signature.</p>
    </div>
</body>
</html>