@extends('adminlte::auth.auth-page', ['auth_type' => 'register'])

@section('auth_header', __('Apply for Special Role'))

@section('auth_body')
    <form action="{{ route('signup.request.store') }}" method="post">
        @csrf

        {{-- Name field --}}
        <div class="input-group mb-3">
            <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                   value="{{ old('name') }}" placeholder="{{ __('Full Name') }}" autofocus>

            <div class="input-group-append">
                <div class="input-group-text">
                    <span class="fas fa-user {{ config('adminlte.classes_auth_icon', '') }}"></span>
                </div>
            </div>

            @error('name')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
        </div>

        {{-- Email field --}}
        <div class="input-group mb-3">
            <input type="email" name="email" class="form-control @error('email') is-invalid @enderror"
                   value="{{ old('email') }}" placeholder="{{ __('Email') }}">

            <div class="input-group-append">
                <div class="input-group-text">
                    <span class="fas fa-envelope {{ config('adminlte.classes_auth_icon', '') }}"></span>
                </div>
            </div>

            @error('email')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
        </div>

        {{-- Requested Role field --}}
        <div class="input-group mb-3">
            <select name="requested_role" class="form-control @error('requested_role') is-invalid @enderror">
                <option value="">{{ __('Select Role') }}</option>
                <option value="brand_admin" {{ old('requested_role') == 'brand_admin' ? 'selected' : '' }}>{{ __('Brand Admin') }}</option>
                <option value="creator" {{ old('requested_role') == 'creator' ? 'selected' : '' }}>{{ __('Creator') }}</option>
                <option value="agency_admin" {{ old('requested_role') == 'agency_admin' ? 'selected' : '' }}>{{ __('Agency Admin') }}</option>
            </select>

            <div class="input-group-append">
                <div class="input-group-text">
                    <span class="fas fa-user-tag {{ config('adminlte.classes_auth_icon', '') }}"></span>
                </div>
            </div>

            @error('requested_role')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
        </div>

        {{-- Company Name field --}}
        <div class="input-group mb-3">
            <input type="text" name="company_name" class="form-control @error('company_name') is-invalid @enderror"
                   value="{{ old('company_name') }}" placeholder="{{ __('Company Name (if applicable)') }}">

            <div class="input-group-append">
                <div class="input-group-text">
                    <span class="fas fa-building {{ config('adminlte.classes_auth_icon', '') }}"></span>
                </div>
            </div>

            @error('company_name')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
        </div>

        {{-- Website field --}}
        <div class="input-group mb-3">
            <input type="text" name="website" class="form-control @error('website') is-invalid @enderror"
                   value="{{ old('website') }}" placeholder="{{ __('Website (if applicable)') }}">

            <div class="input-group-append">
                <div class="input-group-text">
                    <span class="fas fa-globe {{ config('adminlte.classes_auth_icon', '') }}"></span>
                </div>
            </div>

            @error('website')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
        </div>

        {{-- Notes field --}}
        <div class="form-group mb-3">
            <textarea name="notes" class="form-control @error('notes') is-invalid @enderror" 
                      placeholder="{{ __('Additional Notes') }}" rows="3">{{ old('notes') }}</textarea>

            @error('notes')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
        </div>

        {{-- Submit button --}}
        <button type="submit" class="btn btn-block {{ config('adminlte.classes_auth_btn', 'btn-flat btn-primary') }}">
            <span class="fas fa-paper-plane"></span>
            {{ __('Submit Request') }}
        </button>

    </form>
@stop

@section('auth_footer')
    <p class="my-0">
        <a href="{{ route('login') }}">
            {{ __('I already have an account') }}
        </a>
    </p>
    <p class="my-0">
        <a href="{{ route('register') }}">
            {{ __('Public Registration') }}
        </a>
    </p>
@stop