@extends('adminlte::page')

@section('title', 'Message Thread')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Message Thread</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('messages.index') }}">Messages</a></li>
                    <li class="breadcrumb-item active">Thread</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-3">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Thread Information</h3>
                    </div>
                    <div class="card-body">
                        <p><strong>Subject:</strong> {{ $thread->subject ?? 'No Subject' }}</p>
                        
                        <p><strong>Participants:</strong></p>
                        <ul>
                            @foreach($thread->participants as $participant)
                                <li>{{ $participant->user->name }}</li>
                            @endforeach
                        </ul>
                        
                        @if($thread->proposal)
                            <p><strong>Proposal:</strong> 
                                <a href="{{ route('creator.proposals.show', $thread->proposal) }}">
                                    {{ $thread->proposal->title }}
                                </a>
                            </p>
                        @endif
                    </div>
                </div>
            </div>
            
            <div class="col-md-9">
                <div class="card direct-chat direct-chat-primary">
                    <div class="card-header">
                        <h3 class="card-title">Conversation</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="direct-chat-messages" id="message-container" style="height: 500px; overflow-y: auto;">
                            @foreach($messages as $message)
                                @include('messages.partials.message-bubble', ['message' => $message])
                            @endforeach
                        </div>
                    </div>
                    <div class="card-footer">
                        <form action="{{ route('messages.send', $thread) }}" method="POST" enctype="multipart/form-data" id="message-form">
                            @csrf
                            <div class="input-group">
                                <input type="text" name="body" placeholder="Type Message ..." class="form-control" required>
                                <div class="input-group-append">
                                    <button type="button" class="btn btn-info" id="attachment-btn">
                                        <i class="fas fa-paperclip"></i>
                                    </button>
                                    <input type="file" name="attachment" id="attachment-input" accept=".pdf,.jpg,.jpeg,.png,.docx" style="display: none;">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-paper-plane"></i> Send
                                    </button>
                                </div>
                            </div>
                            <div id="attachment-preview" class="mt-2"></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
@parent
<script src="{{ asset('js/messages.js') }}"></script>
@endsection