@php
    $extension = pathinfo($attachmentPath, PATHINFO_EXTENSION);
    $isImage = in_array(strtolower($extension), ['jpg', 'jpeg', 'png']);
@endphp

@if($isImage)
    <div class="attachment-image">
        <img src="{{ Storage::url($attachmentPath) }}" alt="Attachment" class="img-fluid" style="max-height: 200px;">
    </div>
@else
    <div class="attachment-file">
        <a href="{{ Storage::url($attachmentPath) }}" target="_blank">
            <i class="fas fa-file"></i> 
            {{ basename($attachmentPath) }}
        </a>
    </div>
@endif