@extends('layouts.marketing')

@section('title', 'Product Demo - AI Business Market')
@section('description', 'See AI Business Market in action. Watch our interactive demo and discover how to manage creator campaigns with AI-powered tools.')

@push('structured-data')
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "VideoObject",
    "name": "AI Business Market Product Demo",
    "description": "Interactive product demonstration of AI Business Market platform",
    "thumbnailUrl": "{{ asset('images/marketing/demo-thumbnail.jpg') }}",
    "uploadDate": "{{ now()->toIso8601String() }}",
    "duration": "PT3M30S"
}
</script>
@endpush

@section('content')
<div x-data="{ activeTab: 'overview', playing: false }">
    <!-- Hero Section -->
    <section class="bg-gradient-to-br from-blue-50 via-indigo-50 to-purple-50 py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center max-w-3xl mx-auto">
                <span class="inline-block px-4 py-2 bg-blue-100 text-blue-800 rounded-full text-sm font-semibold mb-4">
                    Interactive Demo
                </span>
                <h1 class="text-5xl font-bold text-gray-900 mb-6">
                    See AI Business Market in Action
                </h1>
                <p class="text-xl text-gray-600 mb-8">
                    Explore our platform with an interactive walkthrough. No signup required.
                </p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <button @click="playing = true; gtag('event', 'demo_started', {'event_category': 'engagement'});" 
                            class="inline-flex items-center justify-center px-8 py-4 bg-blue-600 text-white text-lg font-semibold rounded-lg hover:bg-blue-700 transform hover:scale-105 transition-all duration-200 shadow-lg">
                        <svg class="w-6 h-6 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M6.3 2.841A1.5 1.5 0 004 4.11V15.89a1.5 1.5 0 002.3 1.269l9.344-5.89a1.5 1.5 0 000-2.538L6.3 2.84z"/>
                        </svg>
                        Watch Demo Video
                    </button>
                    <a href="{{ route('register') }}" 
                       class="inline-flex items-center justify-center px-8 py-4 bg-white text-gray-900 text-lg font-semibold rounded-lg hover:bg-gray-50 border-2 border-gray-200 transition-all duration-200">
                        Start Free Trial
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Video Player Section -->
    <section class="py-12 bg-white">
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="relative rounded-2xl overflow-hidden shadow-2xl bg-gray-900" style="padding-bottom: 56.25%;">
                <!-- Video Placeholder / Player -->
                <div class="absolute inset-0 flex items-center justify-center">
                    <template x-if="!playing">
                        <div class="relative w-full h-full">
                            <img src="{{ asset('images/marketing/demo-thumbnail.jpg') }}" 
                                 alt="Demo thumbnail" 
                                 class="w-full h-full object-cover"
                                 onerror="this.src='data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' width=\'1200\' height=\'675\'%3E%3Crect fill=\'%23667eea\' width=\'1200\' height=\'675\'/%3E%3Ctext fill=\'%23ffffff\' font-family=\'Arial\' font-size=\'48\' x=\'50%25\' y=\'50%25\' text-anchor=\'middle\' dominant-baseline=\'middle\'%3EDemo Video%3C/text%3E%3C/svg%3E'">
                            <div class="absolute inset-0 bg-black bg-opacity-40 flex items-center justify-center">
                                <button @click="playing = true" 
                                        class="w-20 h-20 bg-white rounded-full flex items-center justify-center hover:scale-110 transition-transform duration-200 shadow-xl">
                                    <svg class="w-10 h-10 text-blue-600 ml-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M6.3 2.841A1.5 1.5 0 004 4.11V15.89a1.5 1.5 0 002.3 1.269l9.344-5.89a1.5 1.5 0 000-2.538L6.3 2.84z"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </template>
                    <template x-if="playing">
                        <div class="w-full h-full">
                            <!-- Replace with actual video embed -->
                            <iframe class="w-full h-full" 
                                    src="https://www.youtube.com/embed/dQw4w9WgXcQ?autoplay=1" 
                                    frameborder="0" 
                                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                                    allowfullscreen></iframe>
                        </div>
                    </template>
                </div>
            </div>
            
            <!-- Video Stats -->
            <div class="grid grid-cols-3 gap-6 mt-8 text-center">
                <div>
                    <div class="text-3xl font-bold text-gray-900">3:30</div>
                    <div class="text-sm text-gray-600 mt-1">Duration</div>
                </div>
                <div>
                    <div class="text-3xl font-bold text-gray-900">10K+</div>
                    <div class="text-sm text-gray-600 mt-1">Views</div>
                </div>
                <div>
                    <div class="text-3xl font-bold text-gray-900">4.9/5</div>
                    <div class="text-sm text-gray-600 mt-1">Rating</div>
                </div>
            </div>
        </div>
    </section>

    <!-- Interactive Feature Tabs -->
    <section class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-4xl font-bold text-gray-900 mb-4">
                    Explore Key Features
                </h2>
                <p class="text-xl text-gray-600">
                    Click through to see how each feature works
                </p>
            </div>

            <!-- Tab Navigation -->
            <div class="flex flex-wrap justify-center gap-4 mb-12">
                <button @click="activeTab = 'overview'" 
                        :class="activeTab === 'overview' ? 'bg-blue-600 text-white' : 'bg-white text-gray-700 hover:bg-gray-50'"
                        class="px-6 py-3 rounded-lg font-semibold transition duration-200 shadow-md">
                    Overview
                </button>
                <button @click="activeTab = 'campaigns'" 
                        :class="activeTab === 'campaigns' ? 'bg-blue-600 text-white' : 'bg-white text-gray-700 hover:bg-gray-50'"
                        class="px-6 py-3 rounded-lg font-semibold transition duration-200 shadow-md">
                    Campaign Management
                </button>
                <button @click="activeTab = 'ai'" 
                        :class="activeTab === 'ai' ? 'bg-blue-600 text-white' : 'bg-white text-gray-700 hover:bg-gray-50'"
                        class="px-6 py-3 rounded-lg font-semibold transition duration-200 shadow-md">
                    AI Tools
                </button>
                <button @click="activeTab = 'analytics'" 
                        :class="activeTab === 'analytics' ? 'bg-blue-600 text-white' : 'bg-white text-gray-700 hover:bg-gray-50'"
                        class="px-6 py-3 rounded-lg font-semibold transition duration-200 shadow-md">
                    Analytics
                </button>
            </div>

            <!-- Tab Content -->
            <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
                <!-- Overview Tab -->
                <div x-show="activeTab === 'overview'" x-cloak class="p-8 md:p-12">
                    <div class="grid md:grid-cols-2 gap-12 items-center">
                        <div>
                            <h3 class="text-3xl font-bold text-gray-900 mb-4">
                                All-in-One Platform
                            </h3>
                            <p class="text-lg text-gray-600 mb-6">
                                Manage your entire creator marketing workflow from a single dashboard. Connect social accounts, create campaigns, generate content, and track performance.
                            </p>
                            <ul class="space-y-3">
                                <li class="flex items-start">
                                    <svg class="w-6 h-6 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="text-gray-700">Unified dashboard for all social platforms</span>
                                </li>
                                <li class="flex items-start">
                                    <svg class="w-6 h-6 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="text-gray-700">Real-time collaboration with team members</span>
                                </li>
                                <li class="flex items-start">
                                    <svg class="w-6 h-6 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="text-gray-700">Automated workflows and scheduling</span>
                                </li>
                            </ul>
                        </div>
                        <div class="relative">
                            <img src="{{ asset('images/marketing/dashboard-screenshot.png') }}" 
                                 alt="Dashboard overview" 
                                 class="rounded-lg shadow-2xl"
                                 onerror="this.src='data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' width=\'800\' height=\'600\'%3E%3Crect fill=\'%23f3f4f6\' width=\'800\' height=\'600\'/%3E%3Ctext fill=\'%236b7280\' font-family=\'Arial\' font-size=\'24\' x=\'50%25\' y=\'50%25\' text-anchor=\'middle\' dominant-baseline=\'middle\'%3EDashboard Screenshot%3C/text%3E%3C/svg%3E'">
                        </div>
                    </div>
                </div>

                <!-- Campaigns Tab -->
                <div x-show="activeTab === 'campaigns'" x-cloak class="p-8 md:p-12">
                    <div class="grid md:grid-cols-2 gap-12 items-center">
                        <div class="order-2 md:order-1 relative">
                            <img src="{{ asset('images/marketing/campaigns-screenshot.png') }}" 
                                 alt="Campaign management" 
                                 class="rounded-lg shadow-2xl"
                                 onerror="this.src='data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' width=\'800\' height=\'600\'%3E%3Crect fill=\'%23f3f4f6\' width=\'800\' height=\'600\'/%3E%3Ctext fill=\'%236b7280\' font-family=\'Arial\' font-size=\'24\' x=\'50%25\' y=\'50%25\' text-anchor=\'middle\' dominant-baseline=\'middle\'%3ECampaigns Screenshot%3C/text%3E%3C/svg%3E'">
                        </div>
                        <div class="order-1 md:order-2">
                            <h3 class="text-3xl font-bold text-gray-900 mb-4">
                                Campaign Management
                            </h3>
                            <p class="text-lg text-gray-600 mb-6">
                                Create, manage, and track campaigns with ease. Set goals, assign creators, manage deliverables, and monitor progress in real-time.
                            </p>
                            <ul class="space-y-3">
                                <li class="flex items-start">
                                    <svg class="w-6 h-6 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="text-gray-700">Visual campaign timeline and milestones</span>
                                </li>
                                <li class="flex items-start">
                                    <svg class="w-6 h-6 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="text-gray-700">Budget tracking and allocation</span>
                                </li>
                                <li class="flex items-start">
                                    <svg class="w-6 h-6 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="text-gray-700">Automated status updates and notifications</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- AI Tools Tab -->
                <div x-show="activeTab === 'ai'" x-cloak class="p-8 md:p-12">
                    <div class="grid md:grid-cols-2 gap-12 items-center">
                        <div>
                            <h3 class="text-3xl font-bold text-gray-900 mb-4">
                                AI-Powered Tools
                            </h3>
                            <p class="text-lg text-gray-600 mb-6">
                                Leverage AI to generate proposals, create content ideas, write captions, and optimize your campaigns for better performance.
                            </p>
                            <ul class="space-y-3">
                                <li class="flex items-start">
                                    <svg class="w-6 h-6 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="text-gray-700">AI proposal generation in seconds</span>
                                </li>
                                <li class="flex items-start">
                                    <svg class="w-6 h-6 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="text-gray-700">Content idea generator with trending topics</span>
                                </li>
                                <li class="flex items-start">
                                    <svg class="w-6 h-6 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="text-gray-700">Smart caption writing and optimization</span>
                                </li>
                            </ul>
                        </div>
                        <div class="relative">
                            <img src="{{ asset('images/marketing/ai-tools-screenshot.png') }}" 
                                 alt="AI tools" 
                                 class="rounded-lg shadow-2xl"
                                 onerror="this.src='data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' width=\'800\' height=\'600\'%3E%3Crect fill=\'%23f3f4f6\' width=\'800\' height=\'600\'/%3E%3Ctext fill=\'%236b7280\' font-family=\'Arial\' font-size=\'24\' x=\'50%25\' y=\'50%25\' text-anchor=\'middle\' dominant-baseline=\'middle\'%3EAI Tools Screenshot%3C/text%3E%3C/svg%3E'">
                        </div>
                    </div>
                </div>

                <!-- Analytics Tab -->
                <div x-show="activeTab === 'analytics'" x-cloak class="p-8 md:p-12">
                    <div class="grid md:grid-cols-2 gap-12 items-center">
                        <div class="order-2 md:order-1 relative">
                            <img src="{{ asset('images/marketing/analytics-screenshot.png') }}" 
                                 alt="Analytics dashboard" 
                                 class="rounded-lg shadow-2xl"
                                 onerror="this.src='data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' width=\'800\' height=\'600\'%3E%3Crect fill=\'%23f3f4f6\' width=\'800\' height=\'600\'/%3E%3Ctext fill=\'%236b7280\' font-family=\'Arial\' font-size=\'24\' x=\'50%25\' y=\'50%25\' text-anchor=\'middle\' dominant-baseline=\'middle\'%3EAnalytics Screenshot%3C/text%3E%3C/svg%3E'">
                        </div>
                        <div class="order-1 md:order-2">
                            <h3 class="text-3xl font-bold text-gray-900 mb-4">
                                Advanced Analytics
                            </h3>
                            <p class="text-lg text-gray-600 mb-6">
                                Track performance metrics, measure ROI, and get actionable insights to optimize your campaigns and grow your business.
                            </p>
                            <ul class="space-y-3">
                                <li class="flex items-start">
                                    <svg class="w-6 h-6 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="text-gray-700">Real-time performance dashboards</span>
                                </li>
                                <li class="flex items-start">
                                    <svg class="w-6 h-6 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="text-gray-700">ROI tracking and attribution</span>
                                </li>
                                <li class="flex items-start">
                                    <svg class="w-6 h-6 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="text-gray-700">Custom reports and exports</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-20 bg-gradient-to-r from-blue-600 to-purple-600 text-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-4xl font-bold mb-6">
                Ready to Get Started?
            </h2>
            <p class="text-xl mb-8 opacity-90">
                Join thousands of brands and creators using AI Business Market
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="{{ route('register') }}" 
                   onclick="gtag('event', 'click', {'event_category': 'CTA', 'event_label': 'Demo Page CTA'});"
                   class="inline-block bg-white text-blue-600 px-8 py-4 rounded-lg font-semibold text-lg hover:bg-gray-100 transition transform hover:scale-105 shadow-xl">
                    Start Free Trial
                </a>
                <a href="{{ route('marketing.pricing') }}" 
                   class="inline-block bg-transparent border-2 border-white text-white px-8 py-4 rounded-lg font-semibold text-lg hover:bg-white/10 transition">
                    View Pricing
                </a>
            </div>
            <p class="text-sm mt-4 opacity-75">No credit card required • 14-day free trial • Cancel anytime</p>
        </div>
    </section>

    <!-- Cookie Consent -->
    <x-marketing.cookie-consent />
</div>
@endsection