@extends('adminlte::page')

@section('title', 'Reel Details')

@section('content_header')
    <h1>Reel #{{ $reel->id }}</h1>
@stop

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Reel Details</h3>
                <div class="card-tools">
                    @if($reel->isReady())
                        <a href="{{ route('creator.reels.download', $reel) }}" class="btn btn-success">
                            <i class="fas fa-download"></i> Download Reel
                        </a>
                    @elseif($reel->hasFailed())
                        <form action="{{ route('creator.reels.retry', $reel) }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-warning" onclick="return confirm('Retry processing this reel?')">
                                <i class="fas fa-redo"></i> Retry Processing
                            </button>
                        </form>
                    @endif
                    <a href="{{ route('creator.reels.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Back to Reels
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        @if($reel->isReady() && $reel->getResultUrl())
                            <div class="video-player">
                                <video controls class="img-fluid" style="max-height: 500px;">
                                    <source src="{{ $reel->getResultUrl() }}" type="video/mp4">
                                    Your browser does not support the video tag.
                                </video>
                            </div>
                        @elseif($reel->isProcessing())
                            <div class="text-center">
                                <div class="spinner-border" role="status">
                                    <span class="sr-only">Processing...</span>
                                </div>
                                <p class="mt-2">Your reel is being processed. This may take a few minutes.</p>
                                <button id="check-status" class="btn btn-primary" data-reel-id="{{ $reel->id }}">
                                    <i class="fas fa-sync"></i> Check Status
                                </button>
                            </div>
                        @elseif($reel->hasFailed())
                            <div class="alert alert-danger">
                                <h4><i class="fas fa-exclamation-triangle"></i> Processing Failed</h4>
                                <p>{{ $reel->error_message ?? 'An unknown error occurred during processing.' }}</p>
                            </div>
                        @else
                            <div class="text-center">
                                <div class="bg-light border rounded p-5">
                                    <i class="fas fa-film fa-3x text-muted"></i>
                                    <p class="mt-3">Reel is queued for processing</p>
                                </div>
                            </div>
                        @endif
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Reel Information</h3>
                            </div>
                            <div class="card-body">
                                <p><strong>Template:</strong> {{ config('reels.templates.' . $reel->template . '.name', $reel->template) }}</p>
                                <p><strong>Status:</strong> 
                                    <span class="badge 
                                        @if($reel->status == 'ready') badge-success
                                        @elseif($reel->status == 'processing') badge-warning
                                        @elseif($reel->status == 'failed') badge-danger
                                        @else badge-secondary
                                        @endif">
                                        {{ ucfirst($reel->status) }}
                                    </span>
                                </p>
                                <p><strong>Created:</strong> {{ $reel->created_at->format('M d, Y H:i') }}</p>
                                <p><strong>Duration:</strong> {{ $reel->duration ? $reel->duration . ' seconds' : 'N/A' }}</p>
                                
                                @if($reel->options && count($reel->options) > 0)
                                <h5>Options</h5>
                                <ul class="list-unstyled">
                                    @foreach($reel->options as $key => $value)
                                        <li><strong>{{ ucfirst(str_replace('_', ' ', $key)) }}:</strong> {{ $value }}</li>
                                    @endforeach
                                </ul>
                                @endif
                            </div>
                        </div>
                        
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Source Posts</h3>
                            </div>
                            <div class="card-body">
                                @if($reel->inputs->count() > 0)
                                    <div class="list-group">
                                        @foreach($reel->inputs as $input)
                                            @if($input->sourcePost)
                                                <div class="list-group-item">
                                                    <div class="d-flex justify-content-between">
                                                        <div>
                                                            <strong>{{ Str::limit($input->sourcePost->caption, 50) }}</strong>
                                                            <br>
                                                            <small class="text-muted">{{ $input->sourcePost->provider }}</small>
                                                        </div>
                                                        <div>
                                                            <small class="text-muted">
                                                                {{ $input->sourcePost->created_at->format('M d, Y') }}
                                                            </small>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                    </div>
                                @else
                                    <p>No source posts associated with this reel.</p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
<script>
    $(document).ready(function() {
        // Check status button
        $('#check-status').click(function() {
            const reelId = $(this).data('reel-id');
            const button = $(this);
            const originalHtml = button.html();
            
            button.html('<i class="fas fa-spinner fa-spin"></i> Checking...');
            button.prop('disabled', true);
            
            // In a real implementation, this would call an API endpoint
            // For now, we'll just reload the page to check status
            setTimeout(function() {
                location.reload();
            }, 2000);
        });
    });
</script>
@stop