@extends('adminlte::page')

@section('title', 'Create Creator Reel')

@section('content_header')
    <h1>Create New Reel</h1>
@stop

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Reel Creation Wizard</h3>
            </div>
            <div class="card-body">
                <form id="reel-form" action="{{ route('creator.reels.store-scheduled') }}" method="POST">
                    @csrf
                    
                    <!-- Step 1: Select Posts -->
                    <div class="step step-1 active">
                        <h4>Select Source Posts</h4>
                        <p>Choose your social media posts to include in the reel</p>
                        
                        @if($socialPosts->count() > 0)
                            <div class="row">
                                @foreach($socialPosts as $post)
                                    <div class="col-md-4 mb-3">
                                        <div class="card post-card" data-post-id="{{ $post->id }}">
                                            <div class="card-body">
                                                <div class="form-check">
                                                    <input type="checkbox" 
                                                           class="form-check-input post-checkbox" 
                                                           id="post_{{ $post->id }}" 
                                                           name="source_inputs[{{ $post->id }}][selected]" 
                                                           value="1">
                                                    <label class="form-check-label" for="post_{{ $post->id }}">
                                                        {{ Str::limit($post->caption, 100) }}
                                                    </label>
                                                </div>
                                                <small class="text-muted">
                                                    {{ $post->provider }} • {{ $post->created_at->format('M d, Y') }}
                                                </small>
                                                @if($post->media_url)
                                                    <div class="mt-2">
                                                        @if(in_array(pathinfo($post->media_url, PATHINFO_EXTENSION), ['jpg', 'jpeg', 'png', 'gif']))
                                                            <img src="{{ $post->media_url }}" alt="Post image" class="img-fluid" style="max-height: 150px;">
                                                        @else
                                                            <div class="text-center">
                                                                <i class="fas fa-file-video fa-3x text-muted"></i>
                                                                <p class="text-muted">Video Content</p>
                                                            </div>
                                                        @endif
                                                    </div>
                                                @endif
                                                
                                                <!-- Hidden fields for post data -->
                                                <input type="hidden" name="source_inputs[{{ $post->id }}][provider]" value="{{ $post->provider }}">
                                                <input type="hidden" name="source_inputs[{{ $post->id }}][source_url]" value="{{ $post->media_url }}">
                                                <input type="hidden" name="source_inputs[{{ $post->id }}][meta][caption]" value="{{ $post->caption }}">
                                                <input type="hidden" name="source_inputs[{{ $post->id }}][meta][created_at]" value="{{ $post->created_at }}">
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="alert alert-info">
                                <p>No social posts available. Connect your social accounts to start creating reels.</p>
                            </div>
                        @endif
                        
                        <div class="form-group mt-3">
                            <button type="button" class="btn btn-primary next-step" disabled>
                                Next: Template <i class="fas fa-arrow-right"></i>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Step 2: Select Template -->
                    <div class="step step-2">
                        <h4>Select Template</h4>
                        <p>Choose a template for your reel</p>
                        
                        <div class="row">
                            @foreach(config('reels.templates') as $templateKey => $template)
                                <div class="col-md-3 mb-3">
                                    <div class="card template-card" data-template="{{ $templateKey }}">
                                        <div class="card-body text-center">
                                            <input type="radio" 
                                                   class="template-radio" 
                                                   id="template_{{ $templateKey }}" 
                                                   name="template" 
                                                   value="{{ $templateKey }}" 
                                                   style="display: none;">
                                            <h5>{{ $template['name'] }}</h5>
                                            <p class="text-muted">{{ $template['description'] }}</p>
                                            <div class="template-preview">
                                                <div class="bg-light border rounded text-center p-3">
                                                    <i class="fas fa-film fa-2x text-muted"></i>
                                                    <p class="mt-2 mb-0">Template Preview</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        
                        <div class="form-group mt-3">
                            <button type="button" class="btn btn-secondary prev-step">
                                <i class="fas fa-arrow-left"></i> Previous
                            </button>
                            <button type="button" class="btn btn-primary next-step">
                                Next: Scheduling <i class="fas fa-arrow-right"></i>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Step 3: Scheduling -->
                    <div class="step step-3">
                        <h4>Scheduling Options</h4>
                        <p>Choose when to post your reel</p>
                        
                        <div class="form-group">
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="schedule_option" id="schedule-now" value="now" checked>
                                <label class="form-check-label" for="schedule-now">
                                    Post Now
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="schedule_option" id="schedule-later" value="schedule">
                                <label class="form-check-label" for="schedule-later">
                                    Schedule for Later
                                </label>
                            </div>
                        </div>
                        
                        <div id="schedule-fields" style="display: none;">
                            <div class="form-group">
                                <label for="scheduled_at">Schedule Date & Time</label>
                                <input type="datetime-local" name="scheduled_at" id="scheduled_at" class="form-control">
                            </div>
                            
                            <div class="form-group">
                                <label for="timezone">Timezone</label>
                                <select name="timezone" id="timezone" class="form-control">
                                    <option value="UTC">UTC</option>
                                    <option value="America/New_York">America/New_York</option>
                                    <option value="America/Los_Angeles">America/Los_Angeles</option>
                                    <option value="Europe/London">Europe/London</option>
                                    <option value="Asia/Tokyo">Asia/Tokyo</option>
                                    <option value="Asia/Kolkata" selected>Asia/Kolkata</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="form-group mt-3">
                            <button type="button" class="btn btn-secondary prev-step">
                                <i class="fas fa-arrow-left"></i> Previous
                            </button>
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-calendar-plus"></i> Schedule Reel
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
<script src="{{ asset('js/reels-scheduler.js') }}"></script>
<script>
    $(document).ready(function() {
        // Initialize reels wizard
        initializeReelsWizard();
        
        // Set up schedule option toggle
        document.querySelectorAll('input[name="schedule_option"]').forEach(radio => {
            radio.addEventListener('change', toggleScheduleFields);
        });
    });
</script>
@stop