@extends('adminlte::page')

@section('title', 'Social Media Providers')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Social Media Providers</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Providers</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Available Social Media Platforms</h3>
                    </div>
                    <div class="card-body">
                        @if(count($providers) > 0)
                            <div class="row">
                                @foreach($providers as $slug => $name)
                                <div class="col-md-6 col-lg-4 mb-3">
                                    <div class="card h-100">
                                        <div class="card-body text-center">
                                            <div class="mb-3">
                                                <i class="fab fa-{{ $slug }} fa-3x"></i>
                                            </div>
                                            <h5 class="card-title">{{ $name }}</h5>
                                            @if(in_array($slug, $userProviders))
                                                <span class="badge badge-success">Connected</span>
                                            @else
                                                <span class="badge badge-secondary">Not Connected</span>
                                            @endif
                                        </div>
                                        <div class="card-footer">
                                            @if(in_array($slug, $userProviders))
                                                <a href="{{ route('creator.provider.show', $slug) }}" class="btn btn-primary btn-sm">
                                                    <i class="fas fa-eye"></i> View Posts
                                                </a>
                                            @else
                                                <a href="{{ route('creator.connections.connect', $slug) }}" class="btn btn-success btn-sm">
                                                    <i class="fas fa-link"></i> Connect
                                                </a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        @else
                            <div class="text-center p-4">
                                <p class="text-muted">No social media providers available at this time.</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection