@extends('adminlte::page')

@section('title', 'Marketplace Opportunities')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Marketplace Opportunities</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('creator.marketplace.index') }}">Marketplace</a></li>
                    <li class="breadcrumb-item active">Opportunities</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Campaign Invitations</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($invitations->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Campaign</th>
                                            <th>Brand</th>
                                            <th>Status</th>
                                            <th>Invited On</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($invitations as $invitation)
                                            <tr>
                                                <td>
                                                    <div class="font-weight-bold">{{ $invitation->campaign->name }}</div>
                                                    <div class="text-muted">{{ Str::limit($invitation->campaign->description, 50) }}</div>
                                                </td>
                                                <td>{{ $invitation->campaign->brand->name }}</td>
                                                <td>
                                                    <span class="badge 
                                                        @if($invitation->status === 'invited') badge-warning
                                                        @elseif($invitation->status === 'accepted') badge-success
                                                        @elseif($invitation->status === 'declined') badge-danger
                                                        @elseif($invitation->status === 'proposal_sent') badge-info
                                                        @elseif($invitation->status === 'proposal_accepted') badge-success
                                                        @elseif($invitation->status === 'proposal_rejected') badge-danger
                                                        @endif">
                                                        {{ ucfirst(str_replace('_', ' ', $invitation->status)) }}
                                                    </span>
                                                </td>
                                                <td>{{ $invitation->created_at->format('M j, Y') }}</td>
                                                <td>
                                                    @if($invitation->status === 'invited')
                                                        <button type="button" class="btn btn-success btn-sm accept-invitation" data-id="{{ $invitation->id }}">
                                                            <i class="fas fa-check"></i> Accept
                                                        </button>
                                                        <button type="button" class="btn btn-danger btn-sm decline-invitation" data-id="{{ $invitation->id }}">
                                                            <i class="fas fa-times"></i> Decline
                                                        </button>
                                                    @elseif($invitation->status === 'accepted')
                                                        <a href="{{ route('creator.proposals.create', ['campaign' => $invitation->campaign->id]) }}" class="btn btn-primary btn-sm">
                                                            <i class="fas fa-file-contract"></i> Create Proposal
                                                        </a>
                                                    @else
                                                        <a href="{{ route('creator.campaigns.show', $invitation->campaign->id) }}" class="btn btn-primary btn-sm">
                                                            <i class="fas fa-eye"></i> View Details
                                                        </a>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Pagination -->
                            <div class="d-flex justify-content-center">
                                {{ $invitations->links() }}
                            </div>
                        @else
                            <div class="text-center p-3">
                                <i class="fas fa-envelope fa-3x text-muted mb-3"></i>
                                <h4>No campaign invitations</h4>
                                <p class="text-muted">
                                    You haven't received any campaign invitations yet.
                                </p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Handle accept invitation
    $('.accept-invitation').on('click', function() {
        const invitationId = $(this).data('id');
        if (confirm('Are you sure you want to accept this invitation?')) {
            // In a real application, you would make an AJAX request to accept the invitation
            alert('Invitation accepted! In a real application, this would be processed on the server.');
        }
    });
    
    // Handle decline invitation
    $('.decline-invitation').on('click', function() {
        const invitationId = $(this).data('id');
        if (confirm('Are you sure you want to decline this invitation?')) {
            // In a real application, you would make an AJAX request to decline the invitation
            alert('Invitation declined! In a real application, this would be processed on the server.');
        }
    });
});
</script>
@endsection