@extends('adminlte::page')

@section('title', 'Campaign Details')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Campaign Details</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('creator.campaigns.index') }}">Campaigns</a></li>
                    <li class="breadcrumb-item active">Details</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">{{ $campaign->name }}</h3>
                        <div class="card-tools">
                            <span class="badge 
                                @if($campaign->status === 'draft') badge-secondary
                                @elseif($campaign->status === 'active') badge-success
                                @elseif($campaign->status === 'paused') badge-warning
                                @elseif($campaign->status === 'completed') badge-primary
                                @elseif($campaign->status === 'cancelled') badge-danger
                                @endif">
                                {{ ucfirst($campaign->status) }}
                            </span>
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Campaign Information</h5>
                                <table class="table table-borderless">
                                    <tr>
                                        <th>Brand:</th>
                                        <td>{{ $campaign->brand->name }}</td>
                                    </tr>
                                    <tr>
                                        <th>Description:</th>
                                        <td>{{ $campaign->description ?? 'Not specified' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Objective:</th>
                                        <td>{{ $campaign->objective ?? 'Not specified' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Budget:</th>
                                        <td>{{ $campaign->budget ? '$' . number_format($campaign->budget, 2) : 'Not specified' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Start Date:</th>
                                        <td>{{ $campaign->start_date ? $campaign->start_date->format('M j, Y') : 'Not specified' }}</td>
                                    </tr>
                                    <tr>
                                        <th>End Date:</th>
                                        <td>{{ $campaign->end_date ? $campaign->end_date->format('M j, Y') : 'Not specified' }}</td>
                                    </tr>
                                </table>
                            </div>
                            
                            <div class="col-md-6">
                                <h5>Your Participation</h5>
                                <table class="table table-borderless">
                                    <tr>
                                        <th>Status:</th>
                                        <td>
                                            <span class="badge 
                                                @if($invitation->status === 'invited') badge-warning
                                                @elseif($invitation->status === 'accepted') badge-success
                                                @elseif($invitation->status === 'declined') badge-danger
                                                @elseif($invitation->status === 'proposal_sent') badge-info
                                                @elseif($invitation->status === 'proposal_accepted') badge-success
                                                @elseif($invitation->status === 'proposal_rejected') badge-danger
                                                @endif">
                                                {{ ucfirst(str_replace('_', ' ', $invitation->status)) }}
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Invited On:</th>
                                        <td>{{ $invitation->created_at->format('M j, Y H:i') }}</td>
                                    </tr>
                                    <tr>
                                        <th>Responded On:</th>
                                        <td>{{ $invitation->responded_at ? $invitation->responded_at->format('M j, Y H:i') : 'Not responded yet' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Notes:</th>
                                        <td>{{ $invitation->notes ?? 'No notes' }}</td>
                                    </tr>
                                </table>
                                
                                @if($invitation->status === 'accepted')
                                <div class="mt-3">
                                    <a href="{{ route('creator.campaigns.planner.show', $campaign) }}" class="btn btn-info">
                                        <i class="fas fa-calendar-alt"></i> Campaign Planner
                                    </a>
                                    <a href="{{ route('creator.proposals.create', ['campaign' => $campaign->id]) }}" class="btn btn-primary">
                                        <i class="fas fa-file-contract"></i> Create Proposal
                                    </a>
                                </div>
                                @endif
                            </div>
                        </div>
                        
                        <div class="row mt-4">
                            <div class="col-12">
                                <h5>Other Creators in Campaign</h5>
                                @if($campaign->creators->count() > 1)
                                    <div class="table-responsive">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Creator</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($campaign->creators as $creator)
                                                    @if($creator->id !== auth()->id())
                                                    <tr>
                                                        <td>{{ $creator->name }}</td>
                                                        <td>
                                                            <span class="badge 
                                                                @if($creator->pivot->status === 'invited') badge-warning
                                                                @elseif($creator->pivot->status === 'accepted') badge-success
                                                                @elseif($creator->pivot->status === 'declined') badge-danger
                                                                @elseif($creator->pivot->status === 'proposal_sent') badge-info
                                                                @elseif($creator->pivot->status === 'proposal_accepted') badge-success
                                                                @elseif($creator->pivot->status === 'proposal_rejected') badge-danger
                                                                @endif">
                                                                {{ ucfirst(str_replace('_', ' ', $creator->pivot->status)) }}
                                                            </span>
                                                        </td>
                                                    </tr>
                                                    @endif
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                @else
                                    <p>You are the only creator in this campaign.</p>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <a href="{{ route('creator.campaigns.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Campaigns
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection