@extends('adminlte::page')

@section('title', 'My Campaigns')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">My Campaigns</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Campaigns</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Campaigns</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-primary" id="createCampaignBtn">
                                <i class="fas fa-plus"></i> Create Campaign
                            </button>
                            <a href="{{ route('creator.campaigns.invitations.index') }}" class="btn btn-info">
                                <i class="fas fa-envelope"></i> View Invitations
                            </a>
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($campaigns->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Campaign</th>
                                            <th>Brand</th>
                                            <th>Status</th>
                                            <th>Start Date</th>
                                            <th>End Date</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($campaigns as $campaign)
                                            <tr>
                                                <td>
                                                    <div class="font-weight-bold">{{ $campaign->name }}</div>
                                                    <div class="text-muted">{{ Str::limit($campaign->description, 50) }}</div>
                                                </td>
                                                <td>{{ $campaign->brand->name }}</td>
                                                <td>
                                                    <span class="badge 
                                                        @if($campaign->status === 'draft') badge-secondary
                                                        @elseif($campaign->status === 'active') badge-success
                                                        @elseif($campaign->status === 'paused') badge-warning
                                                        @elseif($campaign->status === 'completed') badge-primary
                                                        @elseif($campaign->status === 'cancelled') badge-danger
                                                        @endif">
                                                        {{ ucfirst($campaign->status) }}
                                                    </span>
                                                </td>
                                                <td>{{ $campaign->start_date ? $campaign->start_date->format('M j, Y') : 'N/A' }}</td>
                                                <td>{{ $campaign->end_date ? $campaign->end_date->format('M j, Y') : 'N/A' }}</td>
                                                <td>
                                                    <a href="{{ route('creator.campaigns.show', $campaign) }}" class="btn btn-primary btn-sm">
                                                        <i class="fas fa-eye"></i> View
                                                    </a>
                                                    @php
                                                        $creatorPivot = $campaign->creators->firstWhere('id', auth()->id());
                                                    @endphp
                                                    @if($creatorPivot && $creatorPivot->pivot->status === 'owner')
                                                        <a href="{{ route('creator.campaigns.planner.show', $campaign) }}" class="btn btn-info btn-sm">
                                                            <i class="fas fa-calendar-alt"></i> Plan
                                                        </a>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Pagination -->
                            <div class="d-flex justify-content-center">
                                {{ $campaigns->links() }}
                            </div>
                        @else
                            <div class="text-center p-3">
                                <i class="fas fa-bullhorn fa-3x text-muted mb-3"></i>
                                <h4>No campaigns found</h4>
                                <p class="text-muted">
                                    You haven't joined any campaigns yet.
                                </p>
                                <a href="{{ route('creator.campaigns.invitations.index') }}" class="btn btn-info">
                                    <i class="fas fa-envelope"></i> View Campaign Invitations
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Create Campaign Button
    document.getElementById('createCampaignBtn').addEventListener('click', function() {
        // Show a simple prompt for campaign name
        const campaignName = prompt('Enter a name for your new campaign:');
        
        if (campaignName) {
            // Create the campaign via AJAX
            fetch('{{ route("creator.campaigns.create") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    name: campaignName,
                    status: 'draft'
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Redirect to the campaign planner
                    window.location.href = '{{ url("creator/campaigns") }}/' + data.campaign.id + '/planner';
                } else {
                    alert('Error creating campaign.');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error creating campaign.');
            });
        }
    });
});
</script>
@endsection