@extends('layouts.app')

@section('title', 'Auto-Replies - Settings')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Auto-Replies Settings</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('creator.auto-replies.index') }}">Auto-Replies</a></li>
                    <li class="breadcrumb-item active">Settings</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                @if(session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif

                @if(session('info'))
                    <div class="alert alert-info">
                        {{ session('info') }}
                    </div>
                @endif

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Auto-Reply Configuration</h3>
                    </div>
                    <form action="{{ route('creator.auto-replies.settings.update') }}" method="POST">
                        @csrf
                        <div class="card-body">
                            <div class="form-group">
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="enabled" name="enabled" 
                                           {{ old('enabled', $settings->enabled) ? 'checked' : '' }}>
                                    <label class="custom-control-label" for="enabled">Enable Auto-Replies</label>
                                </div>
                                <small class="form-text text-muted">
                                    Toggle to enable or disable the auto-reply feature for your account.
                                </small>
                            </div>

                            <div class="form-group">
                                <label for="preferred_tone">Preferred Tone</label>
                                <select class="form-control" id="preferred_tone" name="preferred_tone">
                                    <option value="casual" {{ old('preferred_tone', $settings->preferred_tone) == 'casual' ? 'selected' : '' }}>
                                        Casual
                                    </option>
                                    <option value="friendly" {{ old('preferred_tone', $settings->preferred_tone) == 'friendly' ? 'selected' : '' }}>
                                        Friendly
                                    </option>
                                    <option value="humorous" {{ old('preferred_tone', $settings->preferred_tone) == 'humorous' ? 'selected' : '' }}>
                                        Humorous
                                    </option>
                                </select>
                                <small class="form-text text-muted">
                                    Select the tone of voice for auto-generated replies.
                                </small>
                            </div>

                            <div class="form-group">
                                <label for="confidence_threshold">Confidence Threshold (%)</label>
                                <input type="number" class="form-control" id="confidence_threshold" name="confidence_threshold" 
                                       min="0" max="100" step="0.01" 
                                       value="{{ old('confidence_threshold', $settings->confidence_threshold) }}">
                                <small class="form-text text-muted">
                                    Minimum confidence score required for human review. Suggestions below this threshold will be skipped.
                                </small>
                            </div>

                            <div class="form-group">
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="auto_approve_high_confidence" 
                                           name="auto_approve_high_confidence" 
                                           {{ old('auto_approve_high_confidence', $settings->auto_approve_high_confidence) ? 'checked' : '' }}>
                                    <label class="custom-control-label" for="auto_approve_high_confidence">Auto-Approve High Confidence Replies</label>
                                </div>
                                <small class="form-text text-muted">
                                    Automatically approve suggestions with confidence scores above the threshold below.
                                </small>
                            </div>

                            <div class="form-group" id="auto_approve_threshold_group" 
                                 style="{{ old('auto_approve_high_confidence', $settings->auto_approve_high_confidence) ? '' : 'display: none;' }}">
                                <label for="auto_approve_confidence_threshold">Auto-Approve Confidence Threshold (%)</label>
                                <input type="number" class="form-control" id="auto_approve_confidence_threshold" 
                                       name="auto_approve_confidence_threshold" 
                                       min="0" max="100" step="0.01" 
                                       value="{{ old('auto_approve_confidence_threshold', $settings->auto_approve_confidence_threshold) }}">
                                <small class="form-text text-muted">
                                    Auto-approve suggestions with confidence scores at or above this threshold.
                                </small>
                            </div>

                            <div class="form-group">
                                <label for="excluded_keywords">Excluded Keywords</label>
                                <textarea class="form-control" id="excluded_keywords" name="excluded_keywords" rows="3" 
                                          placeholder="Enter keywords separated by commas (e.g., spam, buy, discount)">{{ old('excluded_keywords', implode(', ', $settings->excluded_keywords ?? [])) }}</textarea>
                                <small class="form-text text-muted">
                                    Comments containing these keywords will be skipped. Enter keywords separated by commas.
                                </small>
                            </div>

                            <div class="form-group">
                                <label for="creator_guidelines">Creator Guidelines</label>
                                <textarea class="form-control" id="creator_guidelines" name="creator_guidelines" rows="4" 
                                          placeholder="Enter guidelines for replies, one per line">{{ old('creator_guidelines', implode("\n", $settings->creator_guidelines ?? [])) }}</textarea>
                                <small class="form-text text-muted">
                                    Guidelines for the AI to follow when generating replies. Enter one guideline per line.
                                </small>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">Save Settings</button>
                            <a href="{{ route('creator.auto-replies.index') }}" class="btn btn-secondary">Back to Auto-Replies</a>
                        </div>
                    </form>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Rule-Based Triggers</h3>
                    </div>
                    <div class="card-body">
                        <p>Configure rule-based triggers for automatic actions:</p>
                        
                        <div class="form-group">
                            <label>Exclude Users</label>
                            <input type="text" class="form-control" id="exclude_users" name="exclude_users"
                                   placeholder="Enter usernames separated by commas"
                                   value="{{ old('exclude_users', isset($settings->rule_based_triggers['exclude_users']) ? implode(', ', $settings->rule_based_triggers['exclude_users']) : '') }}">
                            <small class="form-text text-muted">
                                Comments from these users will be skipped. Enter usernames separated by commas.
                            </small>
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="exclude_mentions" name="exclude_mentions"
                                       {{ old('exclude_mentions', isset($settings->rule_based_triggers['exclude_mentions']) && $settings->rule_based_triggers['exclude_mentions']) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="exclude_mentions">Exclude Comments with Mentions</label>
                            </div>
                            <small class="form-text text-muted">
                                Skip comments that mention other users.
                            </small>
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="auto_reply_faq" name="auto_reply_faq"
                                       {{ old('auto_reply_faq', isset($settings->rule_based_triggers['auto_reply_faq']) && $settings->rule_based_triggers['auto_reply_faq']) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="auto_reply_faq">Auto-Reply to FAQs</label>
                            </div>
                            <small class="form-text text-muted">
                                Automatically reply to frequently asked questions with predefined responses.
                            </small>
                        </div>
                        
                        <button type="button" class="btn btn-info" id="saveRuleTriggers">Save Rule-Based Triggers</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Toggle auto-approve threshold field
        $('#auto_approve_high_confidence').change(function() {
            if ($(this).is(':checked')) {
                $('#auto_approve_threshold_group').show();
            } else {
                $('#auto_approve_threshold_group').hide();
            }
        });
        
        // Format excluded keywords as array on form submit
        $('form').submit(function() {
            var keywords = $('#excluded_keywords').val();
            if (keywords) {
                var keywordsArray = keywords.split(',').map(function(item) {
                    return item.trim();
                }).filter(function(item) {
                    return item.length > 0;
                });
                $('#excluded_keywords').val(keywordsArray.join(', '));
            }
            
            var guidelines = $('#creator_guidelines').val();
            if (guidelines) {
                var guidelinesArray = guidelines.split('\n').map(function(item) {
                    return item.trim();
                }).filter(function(item) {
                    return item.length > 0;
                });
                $('#creator_guidelines').val(guidelinesArray.join('\n'));
            }
            
            var excludeUsers = $('#exclude_users').val();
            if (excludeUsers) {
                var excludeUsersArray = excludeUsers.split(',').map(function(item) {
                    return item.trim();
                }).filter(function(item) {
                    return item.length > 0;
                });
                $('#exclude_users').val(excludeUsersArray.join(', '));
            }
        });
        
        // Handle rule-based triggers save button
        $('#saveRuleTriggers').click(function() {
            // Get form data
            var formData = {
                '_token': $('input[name="_token"]').val(),
                'exclude_users': $('#exclude_users').val(),
                'exclude_mentions': $('#exclude_mentions').is(':checked'),
                'auto_reply_faq': $('#auto_reply_faq').is(':checked'),
            };
            
            // Submit via AJAX
            $.ajax({
                url: '{{ route('creator.auto-replies.settings.update') }}',
                method: 'POST',
                data: formData,
                success: function(response) {
                    // Show success message
                    $('.alert').remove();
                    $('.content').prepend('<div class="alert alert-success">Rule-based triggers updated successfully!</div>');
                    
                    // Scroll to top
                    $('html, body').animate({ scrollTop: 0 }, 'fast');
                },
                error: function(xhr) {
                    // Show error message
                    $('.alert').remove();
                    $('.content').prepend('<div class="alert alert-danger">Failed to update rule-based triggers. Please try again.</div>');
                    
                    // Scroll to top
                    $('html, body').animate({ scrollTop: 0 }, 'fast');
                }
            });
        });
    });
</script>
@endsection