@extends('layouts.app')

@section('title', 'Auto-Replies - Posted Suggestions')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Posted Auto-Replies</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('creator.auto-replies.index') }}">Auto-Replies</a></li>
                    <li class="breadcrumb-item active">Posted</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                @if(session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger">
                        {{ session('error') }}
                    </div>
                @endif

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Posted Auto-Reply Suggestions</h3>
                        <div class="card-tools">
                            <a href="{{ route('creator.auto-replies.settings') }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-cog"></i> Settings
                            </a>
                            <a href="{{ route('creator.auto-replies.index') }}" class="btn btn-info btn-sm">
                                <i class="fas fa-inbox"></i> Pending
                            </a>
                            <a href="{{ route('creator.auto-replies.approved') }}" class="btn btn-success btn-sm">
                                <i class="fas fa-check-circle"></i> Approved
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($postedSuggestions->isEmpty())
                            <div class="alert alert-info">
                                <h5><i class="icon fas fa-info"></i> No posted suggestions</h5>
                                There are currently no posted auto-reply suggestions. Post approved suggestions to see them here.
                            </div>
                        @else
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>Post</th>
                                            <th>Comment</th>
                                            <th>Posted Reply</th>
                                            <th>Posted At</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($postedSuggestions as $suggestion)
                                            <tr>
                                                <td>
                                                    <div>
                                                        <strong>{{ $suggestion->socialComment->socialPost->title ?? 'Untitled Post' }}</strong>
                                                    </div>
                                                    <div class="text-muted">
                                                        <small>
                                                            {{ $suggestion->socialComment->socialAccount->provider }} - 
                                                            {{ $suggestion->socialComment->socialAccount->meta['name'] ?? 'Unknown Account' }}
                                                        </small>
                                                    </div>
                                                    <div class="text-muted">
                                                        <small>{{ $suggestion->socialComment->published_at->format('M j, Y H:i') }}</small>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-start">
                                                        <img src="{{ $suggestion->socialComment->author_avatar_url ?? asset('vendor/adminlte/dist/img/user2-160x160.jpg') }}" 
                                                             alt="{{ $suggestion->socialComment->author_name }}" 
                                                             class="img-circle mr-2" width="30" height="30">
                                                        <div>
                                                            <strong>{{ $suggestion->socialComment->author_name }}</strong>
                                                            @if($suggestion->socialComment->author_username)
                                                                <small class="text-muted">({{ $suggestion->socialComment->author_username }})</small>
                                                            @endif
                                                            <div>{{ $suggestion->socialComment->content }}</div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="suggested-reply">{{ $suggestion->suggested_reply }}</div>
                                                    <div class="text-muted">
                                                        <small>Tone: {{ ucfirst($suggestion->preferred_tone ?? 'casual') }}</small>
                                                    </div>
                                                </td>
                                                <td>
                                                    {{ $suggestion->posted_at->format('M j, Y H:i') }}
                                                </td>
                                                <td>
                                                    <form action="{{ route('creator.auto-replies.favorite', $suggestion->id) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-warning btn-sm" title="{{ $suggestion->is_favorite ? 'Remove from Favorites' : 'Add to Favorites' }}">
                                                            <i class="fas fa-star{{ $suggestion->is_favorite ? '' : '-o' }}"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <div class="d-flex justify-content-center">
                                {{ $postedSuggestions->links() }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@endsection