@props([
    'plan',
    'featured' => false,
    'interval' => 'monthly',
    'selectedRole' => 'all'
])

@php
    $gradients = [
        'starter' => 'from-gray-500 to-gray-600',
        'pro' => 'from-blue-500 to-blue-600',
        'business' => 'from-purple-500 to-purple-600',
        'enterprise' => 'from-yellow-500 to-yellow-600'
    ];
    $gradient = $gradients[$plan->slug] ?? 'from-blue-500 to-blue-600';
    
    $price = $interval === 'yearly' ? $plan->price * 10 : $plan->price; // 2 months free on yearly
    $savings = $interval === 'yearly' ? $plan->price * 2 : 0;
@endphp

<div class="relative bg-white rounded-2xl shadow-xl overflow-hidden transition-all duration-300 hover:shadow-2xl {{ $featured ? 'ring-4 ring-blue-500 scale-105 z-10' : '' }}"
     x-data="{ showDetails: false }">
    
    @if($featured)
        <div class="absolute top-0 right-0 bg-blue-600 text-white text-xs font-bold px-4 py-1 rounded-bl-lg">
            MOST POPULAR
        </div>
    @endif

    <!-- Header -->
    <div class="bg-gradient-to-r {{ $gradient }} p-6 text-white">
        <h3 class="text-2xl font-bold">{{ $plan->name }}</h3>
        <p class="text-sm opacity-90 mt-1">{{ $plan->description }}</p>
        
        <div class="mt-6">
            @if($plan->isFree())
                <div class="text-4xl font-bold">Free</div>
                <div class="text-sm opacity-90">Forever</div>
            @elseif($plan->slug === 'enterprise')
                <div class="text-4xl font-bold">Custom</div>
                <div class="text-sm opacity-90">Contact sales</div>
            @else
                <div class="flex items-baseline">
                    <span class="text-4xl font-bold">{{ $plan->currency === 'INR' ? '₹' : '$' }}{{ number_format($price, 0) }}</span>
                    <span class="text-lg opacity-90 ml-2">/{{ $interval === 'yearly' ? 'year' : 'month' }}</span>
                </div>
                @if($interval === 'yearly' && $savings > 0)
                    <div class="inline-block bg-green-500 text-white text-xs font-bold px-2 py-1 rounded mt-2">
                        Save {{ $plan->currency === 'INR' ? '₹' : '$' }}{{ number_format($savings, 0) }}
                    </div>
                @endif
            @endif
        </div>

        @if($plan->hasTrial() && !$plan->isFree())
            <div class="mt-4 text-sm opacity-90">
                <svg class="w-4 h-4 inline mr-1" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                </svg>
                {{ $plan->trial_days }}-day free trial
            </div>
        @endif
    </div>

    <!-- Features -->
    <div class="p-6">
        <!-- Feature List -->
        <ul class="space-y-3 mb-6">
            @foreach($plan->features as $feature)
                <li class="flex items-start">
                    <svg class="w-5 h-5 text-green-500 mr-3 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                    </svg>
                    <span class="text-gray-700 text-sm">{{ $feature }}</span>
                </li>
            @endforeach
        </ul>

        <!-- Limits -->
        <div class="border-t border-gray-200 pt-4 mb-6">
            <button @click="showDetails = !showDetails" 
                    class="flex items-center justify-between w-full text-left">
                <h4 class="font-semibold text-gray-900 text-sm">Plan Limits</h4>
                <svg class="w-5 h-5 text-gray-400 transition-transform" 
                     :class="showDetails ? 'rotate-180' : ''"
                     fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                </svg>
            </button>
            
            <div x-show="showDetails" 
                 x-cloak
                 x-transition
                 class="mt-3 space-y-2 text-sm text-gray-600">
                <div class="flex justify-between">
                    <span>Social Accounts:</span>
                    <span class="font-medium">{{ $plan->max_social_accounts === -1 ? 'Unlimited' : $plan->max_social_accounts }}</span>
                </div>
                <div class="flex justify-between">
                    <span>Campaigns:</span>
                    <span class="font-medium">{{ $plan->max_campaigns === -1 ? 'Unlimited' : ($plan->max_campaigns === 0 ? 'None' : $plan->max_campaigns) }}</span>
                </div>
                <div class="flex justify-between">
                    <span>Proposals:</span>
                    <span class="font-medium">{{ $plan->max_proposals === -1 ? 'Unlimited' : $plan->max_proposals }}/month</span>
                </div>
                <div class="flex justify-between">
                    <span>Content Ideas:</span>
                    <span class="font-medium">{{ $plan->max_content_ideas_per_month === -1 ? 'Unlimited' : $plan->max_content_ideas_per_month }}/month</span>
                </div>
                <div class="flex justify-between">
                    <span>Reels:</span>
                    <span class="font-medium">{{ $plan->max_reels_per_month === -1 ? 'Unlimited' : ($plan->max_reels_per_month === 0 ? 'None' : $plan->max_reels_per_month) }}/month</span>
                </div>
                @if($plan->has_ads_manager)
                    <div class="flex justify-between">
                        <span>Ad Variants:</span>
                        <span class="font-medium">{{ $plan->max_ad_variants === -1 ? 'Unlimited' : $plan->max_ad_variants }}</span>
                    </div>
                @endif
            </div>
        </div>

        <!-- CTA Button -->
        @auth
            @if(auth()->user()->currentPlan()?->id === $plan->id)
                <button disabled class="w-full bg-gray-300 text-gray-600 font-semibold py-3 px-6 rounded-lg cursor-not-allowed">
                    Current Plan
                </button>
            @else
                <form action="{{ route('subscription.change-plan', $plan) }}" method="POST">
                    @csrf
                    <button type="submit" 
                            onclick="gtag('event', 'click', {'event_category': 'Pricing', 'event_label': '{{ $plan->name }}'});"
                            class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-6 rounded-lg transition duration-200 transform hover:scale-105">
                        @if(auth()->user()->currentPlan() && $plan->price > auth()->user()->currentPlan()->price)
                            Upgrade to {{ $plan->name }}
                        @elseif(auth()->user()->currentPlan() && $plan->price < auth()->user()->currentPlan()->price)
                            Downgrade to {{ $plan->name }}
                        @else
                            Switch to {{ $plan->name }}
                        @endif
                    </button>
                </form>
            @endif
        @else
            <a href="{{ $plan->slug === 'enterprise' ? '#contact' : route('subscription.checkout', $plan) }}" 
               onclick="gtag('event', 'click', {'event_category': 'Pricing', 'event_label': '{{ $plan->name }}'});"
               class="block w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-6 rounded-lg text-center transition duration-200 transform hover:scale-105">
                @if($plan->isFree())
                    Get Started Free
                @elseif($plan->slug === 'enterprise')
                    Contact Sales
                @else
                    Start {{ $plan->trial_days }}-Day Trial
                @endif
            </a>
        @endauth

        @if(!$plan->isFree() && $plan->slug !== 'enterprise')
            <p class="text-xs text-gray-500 text-center mt-3">
                No credit card required for trial
            </p>
        @endif
    </div>
</div>