<div x-data="{ 
    show: false,
    accepted: false,
    init() {
        this.accepted = localStorage.getItem('cookie_consent') === 'accepted';
        if (!this.accepted) {
            setTimeout(() => { this.show = true; }, 1000);
        }
    },
    accept() {
        localStorage.setItem('cookie_consent', 'accepted');
        localStorage.setItem('cookie_consent_date', new Date().toISOString());
        this.accepted = true;
        this.show = false;
        
        // Initialize analytics after consent
        if (typeof gtag !== 'undefined') {
            gtag('consent', 'update', {
                'analytics_storage': 'granted',
                'ad_storage': 'granted'
            });
        }
        
        // Fire consent event
        if (typeof gtag !== 'undefined') {
            gtag('event', 'cookie_consent_granted', {
                'event_category': 'consent',
                'event_label': 'accepted'
            });
        }
    },
    decline() {
        localStorage.setItem('cookie_consent', 'declined');
        localStorage.setItem('cookie_consent_date', new Date().toISOString());
        this.show = false;
        
        // Deny analytics
        if (typeof gtag !== 'undefined') {
            gtag('consent', 'update', {
                'analytics_storage': 'denied',
                'ad_storage': 'denied'
            });
        }
    }
}" 
x-show="show"
x-cloak
x-transition:enter="transition ease-out duration-300"
x-transition:enter-start="opacity-0 translate-y-4"
x-transition:enter-end="opacity-100 translate-y-0"
x-transition:leave="transition ease-in duration-200"
x-transition:leave-start="opacity-100 translate-y-0"
x-transition:leave-end="opacity-0 translate-y-4"
class="fixed bottom-0 left-0 right-0 z-50 p-4 md:p-6"
role="dialog"
aria-live="polite"
aria-label="Cookie consent banner">
    
    <div class="max-w-7xl mx-auto">
        <div class="bg-white rounded-2xl shadow-2xl border border-gray-200 overflow-hidden">
            <div class="p-6 md:p-8">
                <div class="flex flex-col md:flex-row items-start md:items-center gap-6">
                    <!-- Icon -->
                    <div class="flex-shrink-0">
                        <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4"/>
                            </svg>
                        </div>
                    </div>

                    <!-- Content -->
                    <div class="flex-1">
                        <h3 class="text-lg font-bold text-gray-900 mb-2">
                            We Value Your Privacy
                        </h3>
                        <p class="text-sm text-gray-600 leading-relaxed">
                            We use cookies to enhance your browsing experience, analyze site traffic, and personalize content. 
                            By clicking "Accept All", you consent to our use of cookies. 
                            <a href="#" class="text-blue-600 hover:text-blue-700 underline font-medium">Learn more</a>
                        </p>
                        
                        <!-- Cookie Types (Optional detailed view) -->
                        <div class="mt-3 text-xs text-gray-500">
                            <span class="inline-flex items-center mr-4">
                                <svg class="w-3 h-3 text-green-500 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                Essential
                            </span>
                            <span class="inline-flex items-center mr-4">
                                <svg class="w-3 h-3 text-blue-500 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                Analytics
                            </span>
                            <span class="inline-flex items-center">
                                <svg class="w-3 h-3 text-purple-500 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                Marketing
                            </span>
                        </div>
                    </div>

                    <!-- Actions -->
                    <div class="flex flex-col sm:flex-row gap-3 w-full md:w-auto">
                        <button @click="decline()" 
                                class="px-6 py-2.5 border-2 border-gray-300 text-gray-700 font-semibold rounded-lg hover:bg-gray-50 transition duration-200 whitespace-nowrap">
                            Decline
                        </button>
                        <button @click="accept()" 
                                class="px-6 py-2.5 bg-blue-600 text-white font-semibold rounded-lg hover:bg-blue-700 transition duration-200 shadow-lg hover:shadow-xl whitespace-nowrap">
                            Accept All
                        </button>
                    </div>
                </div>

                <!-- Additional Links -->
                <div class="mt-4 pt-4 border-t border-gray-200 flex flex-wrap gap-4 text-xs text-gray-500">
                    <a href="#" class="hover:text-gray-700 transition">Cookie Policy</a>
                    <a href="#" class="hover:text-gray-700 transition">Privacy Policy</a>
                    <a href="#" class="hover:text-gray-700 transition">Terms of Service</a>
                    <a href="#" class="hover:text-gray-700 transition">Manage Preferences</a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Initialize Google Consent Mode (before analytics load) -->
<script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    
    // Default consent to denied
    gtag('consent', 'default', {
        'analytics_storage': 'denied',
        'ad_storage': 'denied',
        'wait_for_update': 500
    });
    
    // Check if user has already consented
    if (localStorage.getItem('cookie_consent') === 'accepted') {
        gtag('consent', 'update', {
            'analytics_storage': 'granted',
            'ad_storage': 'granted'
        });
    }
</script>