@extends('adminlte::page')

@section('title', 'Pending Agency Proposals')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Pending Agency Proposals</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.proposals.index') }}">Proposals</a></li>
                    <li class="breadcrumb-item active">Pending Agency Proposals</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Agency Proposals Awaiting Your Approval</h3>
                    </div>
                    <div class="card-body">
                        @if($proposals->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Title</th>
                                            <th>Agency</th>
                                            <th>Creator</th>
                                            <th>Type</th>
                                            <th>Budget</th>
                                            <th>Date Created</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($proposals as $proposal)
                                            <tr>
                                                <td>{{ $proposal->title }}</td>
                                                <td>{{ $proposal->agency->name ?? 'Unknown Agency' }}</td>
                                                <td>{{ $proposal->creator->name ?? 'Not specified' }}</td>
                                                <td>{{ $proposal->type }}</td>
                                                <td>{{ $proposal->budget ? '$' . number_format($proposal->budget, 2) : 'N/A' }}</td>
                                                <td>{{ $proposal->created_at->format('M j, Y') }}</td>
                                                <td>
                                                    <a href="{{ route('brand.agency-proposals.show', $proposal) }}" class="btn btn-primary btn-sm">
                                                        <i class="fas fa-eye"></i> Review
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center p-3">
                                <i class="fas fa-file-contract fa-3x text-muted mb-3"></i>
                                <h4>No pending agency proposals</h4>
                                <p class="text-muted">
                                    There are currently no agency-generated proposals awaiting your approval.
                                </p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection