@extends('adminlte::page')

@section('title', 'Message Thread')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Message Thread</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.messages.index') }}">Messages</a></li>
                    <li class="breadcrumb-item active">Thread</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            {{ $thread->subject ?? 'Message Thread' }}
                        </h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Participants -->
                        <div class="mb-3">
                            <strong>Participants:</strong>
                            @foreach($participants as $participant)
                                <span class="badge badge-secondary">
                                    {{ $participant->user->name }}
                                </span>
                            @endforeach
                        </div>
                        
                        <!-- Messages -->
                        <div class="direct-chat-messages" style="height: 500px; overflow-y: auto;">
                            @foreach($messages as $message)
                                @if($message->sender_id == auth()->id())
                                    <!-- Message to the right (current user) -->
                                    <div class="direct-chat-msg right">
                                        <div class="direct-chat-infos clearfix">
                                            <span class="direct-chat-name float-right">{{ $message->sender->name }}</span>
                                            <span class="direct-chat-timestamp float-left">{{ $message->created_at->format('M j, Y H:i') }}</span>
                                        </div>
                                        <img class="direct-chat-img" src="{{ $message->sender->avatar_url ?? asset('vendor/adminlte/dist/img/user2-160x160.jpg') }}" alt="Message User Image">
                                        <div class="direct-chat-text">
                                            {{ $message->message }}
                                            @if($message->attachment_path)
                                                <div class="mt-2">
                                                    <a href="{{ Storage::url($message->attachment_path) }}" target="_blank" class="btn btn-info btn-xs">
                                                        <i class="fas fa-paperclip"></i> Attachment
                                                    </a>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @else
                                    <!-- Message to the left (other user) -->
                                    <div class="direct-chat-msg">
                                        <div class="direct-chat-infos clearfix">
                                            <span class="direct-chat-name float-left">{{ $message->sender->name }}</span>
                                            <span class="direct-chat-timestamp float-right">{{ $message->created_at->format('M j, Y H:i') }}</span>
                                        </div>
                                        <img class="direct-chat-img" src="{{ $message->sender->avatar_url ?? asset('vendor/adminlte/dist/img/user1-128x128.jpg') }}" alt="Message User Image">
                                        <div class="direct-chat-text">
                                            {{ $message->message }}
                                            @if($message->attachment_path)
                                                <div class="mt-2">
                                                    <a href="{{ Storage::url($message->attachment_path) }}" target="_blank" class="btn btn-info btn-xs">
                                                        <i class="fas fa-paperclip"></i> Attachment
                                                    </a>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                    <div class="card-footer">
                        <form action="{{ route('brand.messages.reply', $thread) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="input-group">
                                <input type="text" name="message" placeholder="Type Message ..." class="form-control" required>
                                <div class="input-group-append">
                                    <button type="button" class="btn btn-info" id="attachment-button">
                                        <i class="fas fa-paperclip"></i>
                                    </button>
                                    <input type="file" name="attachment" id="attachment-input" class="d-none">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-paper-plane"></i> Send
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Scroll to bottom of messages
    var messagesContainer = document.querySelector('.direct-chat-messages');
    if (messagesContainer) {
        messagesContainer.scrollTop = messagesContainer.scrollHeight;
    }
    
    // Attachment button click
    document.getElementById('attachment-button').addEventListener('click', function() {
        document.getElementById('attachment-input').click();
    });
    
    // Update file label when file is selected
    document.getElementById('attachment-input').addEventListener('change', function() {
        if (this.files.length > 0) {
            alert('Attachment selected: ' + this.files[0].name);
        }
    });
});
</script>
@endsection