@extends('adminlte::page')

@section('title', 'Messages')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Messages</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Messages</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Your Messages</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($threads->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Subject</th>
                                            <th>Participants</th>
                                            <th>Last Message</th>
                                            <th>Date</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($threads as $thread)
                                            <tr>
                                                <td>
                                                    @if(!$thread->participants()->where('user_id', auth()->id())->first()->is_read)
                                                        <strong>{{ $thread->subject ?? 'No Subject' }}</strong>
                                                    @else
                                                        {{ $thread->subject ?? 'No Subject' }}
                                                    @endif
                                                </td>
                                                <td>
                                                    @php
                                                        $otherParticipants = $thread->participants()->where('user_id', '!=', auth()->id())->get();
                                                    @endphp
                                                    @if($otherParticipants->count() > 0)
                                                        {{ $otherParticipants->first()->user->name }}
                                                        @if($otherParticipants->count() > 1)
                                                            +{{ $otherParticipants->count() - 1 }} more
                                                        @endif
                                                    @else
                                                        Unknown
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($thread->latestMessage)
                                                        {{ \Illuminate\Support\Str::limit($thread->latestMessage->message, 50) }}
                                                    @else
                                                        No messages yet
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($thread->updated_at)
                                                        {{ $thread->updated_at->format('M j, Y H:i') }}
                                                    @else
                                                        N/A
                                                    @endif
                                                </td>
                                                <td>
                                                    @if(!$thread->participants()->where('user_id', auth()->id())->first()->is_read)
                                                        <span class="badge badge-warning">Unread</span>
                                                    @else
                                                        <span class="badge badge-secondary">Read</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <a href="{{ route('brand.messages.show', $thread) }}" class="btn btn-primary btn-sm">
                                                        <i class="fas fa-eye"></i> View
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Pagination -->
                            <div class="d-flex justify-content-center">
                                {{ $threads->links() }}
                            </div>
                        @else
                            <div class="text-center p-3">
                                <i class="fas fa-envelope fa-3x text-muted mb-3"></i>
                                <h4>No messages found</h4>
                                <p class="text-muted">
                                    You don't have any messages yet.
                                </p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection