@extends('adminlte::page')

@section('title', 'Marketplace')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Creator Marketplace</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Marketplace</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <!-- Filter Panel -->
            <div class="col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Filters</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <form id="filterForm" method="GET" action="{{ route('brand.marketplace.index') }}">
                            <div class="form-group">
                                <label for="influencer_types">Influencer Type</label>
                                <select name="types[]" id="influencer_types" class="form-control select2" multiple>
                                    @foreach($allTypes as $type)
                                        <option value="{{ $type }}" {{ in_array($type, request('types', [])) ? 'selected' : '' }}>
                                            {{ $type }}
                                        </option>
                                    @endforeach
                                </select>
                                <small class="form-text text-muted">Select one or more influencer types</small>
                            </div>
                            
                            <div class="form-group">
                                <label for="followers_min">Minimum Followers</label>
                                <input type="number" name="followers_min" id="followers_min" class="form-control" 
                                       value="{{ request('followers_min') }}" placeholder="0">
                            </div>
                            
                            <div class="form-group">
                                <label for="followers_max">Maximum Followers</label>
                                <input type="number" name="followers_max" id="followers_max" class="form-control" 
                                       value="{{ request('followers_max') }}" placeholder="1000000">
                            </div>
                            
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary" id="applyFilters">
                                    <i class="fas fa-filter"></i> Apply Filters
                                </button>
                                <a href="{{ route('brand.marketplace.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> Clear
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
                
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Shortlists</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <a href="{{ route('brand.marketplace.shortlists.index') }}" class="btn btn-primary btn-block">
                            <i class="fas fa-list"></i> Manage Shortlists
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Creators List -->
            <div class="col-lg-9">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Creators</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($creators->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Creator</th>
                                            <th>Influencer Type</th>
                                            <th>Total Followers</th>
                                            <th>Total Posts</th>
                                            <th>Engagement Rate</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($creators as $creator)
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        @if($creator->avatar_url)
                                                            <img src="{{ $creator->avatar_url }}" alt="Avatar" class="img-circle mr-2" style="width: 40px; height: 40px; object-fit: cover;">
                                                        @else
                                                            <div class="bg-light border rounded-circle mr-2 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                                <i class="fas fa-user text-muted"></i>
                                                            </div>
                                                        @endif
                                                        <div>
                                                            <div class="font-weight-bold">{{ $creator->name }}</div>
                                                            <div class="text-muted">{{ $creator->email }}</div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    @if($creator->influencer_type === 'Other' && $creator->influencer_type_custom)
                                                        <span class="badge badge-info">{{ $creator->influencer_type_custom }}</span>
                                                    @else
                                                        <span class="badge badge-info">{{ $creator->influencer_type ?? 'Not specified' }}</span>
                                                    @endif
                                                </td>
                                                @php
                                                    $followers = $creator->socialAggregates->firstWhere('key', 'total_followers');
                                                    $posts = $creator->socialAggregates->firstWhere('key', 'total_posts');
                                                    $engagement = $creator->socialAggregates->firstWhere('key', 'engagement_rate');
                                                @endphp
                                                <td>{{ number_format($followers ? $followers->getNumericValue() : 0) }}</td>
                                                <td>{{ number_format($posts ? $posts->getNumericValue() : 0) }}</td>
                                                <td>{{ number_format($engagement ? $engagement->getNumericValue() : 0, 2) }}%</td>
                                                <td>
                                                    <a href="{{ route('brand.creators.show', $creator) }}" class="btn btn-primary btn-sm">
                                                        <i class="fas fa-eye"></i> View
                                                    </a>
                                                    <button type="button" class="btn btn-success btn-sm" 
                                                            onclick="addToShortlist({{ $creator->id }})">
                                                        <i class="fas fa-plus"></i> Add to Shortlist
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Pagination -->
                            <div class="d-flex justify-content-center">
                                {{ $creators->links() }}
                            </div>
                        @else
                            <div class="text-center p-3">
                                <i class="fas fa-user-friends fa-3x text-muted mb-3"></i>
                                <h4>No creators found</h4>
                                <p class="text-muted">
                                    @if(empty(request('types')) && !request('followers_min') && !request('followers_max'))
                                        There are no creators available at the moment.
                                    @else
                                        No creators match your selected filters. Try adjusting your filters.
                                    @endif
                                </p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Select2 for multi-select
    if ($.fn.select2) {
        $('#influencer_types').select2({
            placeholder: 'Select influencer types',
            allowClear: true
        });
    }
    
    // Handle form submission with loading indicator
    $('#filterForm').on('submit', function() {
        $('#applyFilters').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Applying...');
    });
    
    // Add to shortlist function
    window.addToShortlist = function(creatorId) {
        // This would make an AJAX call to add the creator to a shortlist
        alert('Add to shortlist functionality would be implemented here');
    };
});
</script>
@endsection