@extends('layouts.brand')

@section('title', 'Ad Manager')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h1 class="h3 mb-0">Ad Manager</h1>
                <a href="{{ route('brand.ads.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Create New Ad
                </a>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Your Ads</h5>
                </div>
                <div class="card-body">
                    @if($ads->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Campaign</th>
                                        <th>Status</th>
                                        <th>Variants</th>
                                        <th>Budget</th>
                                        <th>Created</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($ads as $ad)
                                        <tr>
                                            <td>
                                                <a href="{{ route('brand.ads.show', $ad) }}" class="text-decoration-none">
                                                    {{ $ad->name }}
                                                </a>
                                            </td>
                                            <td>{{ $ad->campaign->name ?? 'N/A' }}</td>
                                            <td>
                                                <span class="badge bg-{{ $ad->status === 'active' ? 'success' : ($ad->status === 'paused' ? 'warning' : 'secondary') }}">
                                                    {{ ucfirst($ad->status) }}
                                                </span>
                                            </td>
                                            <td>
                                                <span class="badge bg-info">
                                                    {{ $ad->variants->count() }} variants
                                                </span>
                                                @if($ad->hasWinner())
                                                    <i class="fas fa-trophy text-warning ms-1" title="Has winner"></i>
                                                @endif
                                            </td>
                                            <td>{{ $ad->currency }} {{ number_format($ad->budget, 2) }}</td>
                                            <td>{{ $ad->created_at->format('M d, Y') }}</td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="{{ route('brand.ads.show', $ad) }}" class="btn btn-outline-primary" title="View">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="{{ route('brand.ads.ab-test', $ad) }}" class="btn btn-outline-info" title="A/B Test Dashboard">
                                                        <i class="fas fa-chart-line"></i>
                                                    </a>
                                                    <a href="{{ route('brand.ads.edit', $ad) }}" class="btn btn-outline-secondary" title="Edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="{{ route('brand.ads.destroy', $ad) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this ad?')">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-outline-danger" title="Delete">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-3">
                            {{ $ads->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-ad fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No ads created yet. Create your first ad to get started!</p>
                            <a href="{{ route('brand.ads.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus me-2"></i>Create Your First Ad
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection