<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Tenant;

class TestUsersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
        {
            $tenant = Tenant::where('domain', 'demo.local')->first();
    
            if (!$tenant) {
                throw new \Exception('Demo tenant not found. Please run TenantsSeeder first.');
            }
    
            // Create users only if they don't already exist
            $users = [
                [
                    'email' => 'super@demo.local',
                    'name' => 'Super Admin',
                    'role' => 'superadmin'
                ],
                [
                    'email' => 'brand@demo.local',
                    'name' => 'Brand Admin',
                    'role' => 'brand_admin'
                ],
                [
                    'email' => 'creator@demo.local',
                    'name' => 'Creator',
                    'role' => 'creator'
                ],
                [
                    'email' => 'agency@demo.local',
                    'name' => 'Agency Admin',
                    'role' => 'agency_admin'
                ],
                [
                    'email' => 'user@demo.local',
                    'name' => 'User',
                    'role' => 'user'
                ]
            ];
            
            foreach ($users as $userData) {
                $user = User::firstOrCreate([
                    'email' => $userData['email']
                ], [
                    'tenant_id' => $tenant->id,
                    'name' => $userData['name'],
                    'phone' => null,
                    'meta' => null,
                    'password' => bcrypt('password123'),
                ]);
                
                // Assign role only if not already assigned
                if (!$user->hasRole($userData['role'])) {
                    $user->assignRole($userData['role']);
                }
            }
        }
}
