<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class RolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
        {
            // Create roles only if they don't already exist
            $roles = [
                'superadmin',
                'brand_admin',
                'agency_admin',
                'creator',
                'user'
            ];
            
            foreach ($roles as $role) {
                if (!Role::where('name', $role)->where('guard_name', 'web')->exists()) {
                    Role::create(['name' => $role]);
                }
            }
        }
}
