<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('budget_scenarios', function (Blueprint $table) {
            $table->id();
            $table->foreignId('brand_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('financial_report_id')->nullable()->constrained()->onDelete('set null');
            
            // Scenario Details
            $table->string('name');
            $table->enum('scenario_type', ['conservative', 'balanced', 'aggressive'])->default('balanced');
            $table->text('description')->nullable();
            
            // Budget Allocation
            $table->decimal('total_budget', 15, 2);
            $table->json('channel_allocation')->nullable(); // {instagram: 40%, tiktok: 30%, youtube: 30%}
            $table->json('campaign_allocation')->nullable(); // {campaign_1: 50%, campaign_2: 50%}
            
            // Projected Outcomes
            $table->decimal('projected_revenue', 15, 2)->nullable();
            $table->decimal('projected_roi', 10, 2)->nullable();
            $table->integer('projected_conversions')->nullable();
            $table->decimal('projected_cost_per_conversion', 10, 2)->nullable();
            
            // AI Recommendations
            $table->json('ai_recommendations')->nullable();
            $table->text('risk_assessment')->nullable();
            $table->json('optimization_suggestions')->nullable();
            
            // Comparison with current
            $table->decimal('roi_improvement', 10, 2)->nullable(); // % improvement over current
            $table->decimal('revenue_increase', 15, 2)->nullable();
            
            // Status
            $table->enum('status', ['draft', 'active', 'archived'])->default('draft');
            $table->boolean('is_applied')->default(false);
            $table->timestamp('applied_at')->nullable();
            
            $table->timestamps();
            $table->softDeletes();
            
            // Indexes
            $table->index(['brand_id', 'scenario_type', 'status']);
            $table->index('financial_report_id');
            $table->index('is_applied');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('budget_scenarios');
    }
};