<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('support_bot_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('brand_id')->unique()->constrained()->onDelete('cascade');
            $table->boolean('bot_enabled')->default(true);
            $table->decimal('confidence_threshold', 5, 2)->default(70.00); // Escalate if below
            $table->integer('max_messages_before_escalation')->default(10);
            $table->json('business_hours')->nullable(); // Operating hours
            $table->text('welcome_message')->nullable();
            $table->text('escalation_message')->nullable();
            $table->text('offline_message')->nullable();
            $table->json('widget_settings')->nullable(); // colors, position, branding
            $table->json('pii_redaction_rules')->nullable(); // Custom PII patterns
            $table->boolean('collect_feedback')->default(true);
            $table->boolean('enable_human_handoff')->default(true);
            $table->json('notification_settings')->nullable(); // Email/Slack alerts
            $table->string('fallback_email')->nullable();
            $table->timestamps();

            $table->index('brand_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('support_bot_settings');
    }
};