<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('localized_contents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('brand_id')->constrained()->onDelete('cascade');
            $table->string('content_type'); // 'ad', 'post', 'proposal', 'campaign'
            $table->unsignedBigInteger('content_id'); // polymorphic reference
            $table->string('locale_code', 10); // e.g., 'en-US', 'es-ES', 'fr-FR'
            $table->text('source_text');
            $table->text('localized_text');
            $table->text('cultural_notes')->nullable();
            $table->string('tone')->default('neutral'); // formal, friendly, neutral
            $table->string('ai_job_id')->nullable();
            $table->enum('status', ['pending', 'generated', 'approved', 'rejected', 'edited'])->default('pending');
            $table->foreignId('approved_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamp('approved_at')->nullable();
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();

            // Indexes
            $table->index(['brand_id', 'content_type', 'content_id']);
            $table->index(['locale_code', 'status']);
            $table->index('ai_job_id');
            $table->unique(['content_type', 'content_id', 'locale_code'], 'unique_content_locale');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('localized_contents');
    }
};