<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ad_variants', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('ad_id');
            $table->string('headline');
            $table->text('body');
            $table->string('cta')->nullable();
            $table->text('predicted_metrics')->nullable(); // JSON field for predicted performance metrics
            $table->boolean('is_active')->default(true);
            $table->boolean('is_winner')->default(false);
            $table->timestamps();

            // Foreign key constraints
            $table->foreign('ad_id')->references('id')->on('ads')->onDelete('cascade');

            // Indexes
            $table->index('ad_id');
            $table->index('is_active');
            $table->index('is_winner');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ad_variants');
    }
};