<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('creator_scheduled_posts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('social_account_id')->nullable();
            $table->text('caption')->nullable();
            $table->json('media_refs')->nullable();
            $table->timestamp('publish_time')->nullable();
            $table->string('status')->default('draft'); // draft, scheduled, publishing, posted, failed, cancelled
            $table->string('timezone')->nullable();
            $table->json('retry_policy')->nullable();
            $table->string('idempotency_key')->unique()->nullable();
            $table->unsignedBigInteger('campaign_id')->nullable();
            $table->string('post_visibility')->default('public'); // public, draft
            $table->json('recurrence')->nullable();
            $table->string('remote_post_id')->nullable();
            $table->json('provider_response')->nullable();
            $table->text('error_message')->nullable();
            $table->unsignedInteger('attempt_count')->default(0);
            $table->timestamp('last_attempt_at')->nullable();
            $table->timestamp('next_retry_at')->nullable();
            $table->boolean('auto_reply_enabled')->default(false);
            $table->unsignedBigInteger('auto_reply_template_id')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index('user_id');
            $table->index('social_account_id');
            $table->index('publish_time');
            $table->index('status');
            $table->index('campaign_id');
            $table->index('auto_reply_template_id');
            $table->index('next_retry_at');
            
            // Foreign key constraints
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('social_account_id')->references('id')->on('social_accounts')->onDelete('set null');
            $table->foreign('campaign_id')->references('id')->on('campaigns')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('creator_scheduled_posts');
    }
};