<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scheduled_posts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('brand_id');
            $table->unsignedBigInteger('social_account_id')->nullable();
            $table->text('caption')->nullable();
            $table->json('media_refs')->nullable();
            $table->timestamp('publish_time')->nullable();
            $table->string('status')->default('draft'); // draft, pending_approval, scheduled, publishing, posted, failed, cancelled, denied
            $table->string('timezone')->nullable();
            $table->json('retry_policy')->nullable();
            $table->string('idempotency_key')->unique()->nullable();
            $table->unsignedBigInteger('ai_job_id')->nullable();
            $table->unsignedBigInteger('campaign_id')->nullable();
            $table->string('post_visibility')->default('public'); // public, draft
            $table->json('recurrence')->nullable();
            $table->boolean('approval_required')->default(false);
            $table->unsignedBigInteger('approved_by')->nullable();
            $table->timestamp('approved_at')->nullable();
            $table->string('remote_post_id')->nullable();
            $table->json('provider_response')->nullable();
            $table->text('error_message')->nullable();
            $table->unsignedInteger('attempt_count')->default(0);
            $table->timestamp('last_attempt_at')->nullable();
            $table->timestamp('next_retry_at')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
            
            // Indexes
            $table->index('brand_id');
            $table->index('social_account_id');
            $table->index('publish_time');
            $table->index('status');
            $table->index('campaign_id');
            $table->index('ai_job_id');
            $table->index('created_by');
            $table->index('approved_by');
            $table->index('next_retry_at');
            
            // Foreign key constraints
            $table->foreign('brand_id')->references('id')->on('brands')->onDelete('cascade');
            $table->foreign('social_account_id')->references('id')->on('social_accounts')->onDelete('set null');
            $table->foreign('ai_job_id')->references('id')->on('ai_jobs')->onDelete('set null');
            $table->foreign('campaign_id')->references('id')->on('campaigns')->onDelete('set null');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('approved_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scheduled_posts');
    }
};
