<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('auto_reply_settings', function (Blueprint $table) {
            // Check if user_id column exists before adding it
            if (!Schema::hasColumn('auto_reply_settings', 'user_id')) {
                // Add user_id column
                $table->unsignedBigInteger('user_id')->nullable()->after('creator_id');
            }
            
            // Check if preferred_tone column exists before adding it
            if (!Schema::hasColumn('auto_reply_settings', 'preferred_tone')) {
                // Add preferred_tone column
                $table->string('preferred_tone')->default('casual')->after('brand_voice');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('auto_reply_settings', function (Blueprint $table) {
            // Check if user_id column exists before dropping it
            if (Schema::hasColumn('auto_reply_settings', 'user_id')) {
                // Remove the added columns
                $table->dropColumn('user_id');
            }
            
            // Check if preferred_tone column exists before dropping it
            if (Schema::hasColumn('auto_reply_settings', 'preferred_tone')) {
                $table->dropColumn('preferred_tone');
            }
        });
    }
};
