<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('auto_reply_suggestions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('social_comment_id');
            $table->unsignedBigInteger('brand_id')->nullable();
            $table->unsignedBigInteger('creator_id')->nullable();
            $table->unsignedBigInteger('ai_job_id')->nullable();
            $table->text('suggested_reply');
            $table->decimal('confidence_score', 5, 2)->default(0);
            $table->string('brand_voice')->nullable();
            $table->string('preferred_tone')->nullable();
            $table->boolean('is_approved')->default(false);
            $table->boolean('is_posted')->default(false);
            $table->boolean('is_favorite')->default(false);
            $table->timestamp('posted_at')->nullable();
            $table->json('meta')->nullable();
            $table->timestamps();
            
            $table->foreign('social_comment_id')->references('id')->on('social_comments')->onDelete('cascade');
            $table->foreign('brand_id')->references('id')->on('brands')->onDelete('cascade');
            $table->foreign('creator_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('ai_job_id')->references('id')->on('ai_jobs')->onDelete('set null');
            
            $table->index(['social_comment_id', 'created_at']);
            $table->index(['brand_id', 'created_at']);
            $table->index(['creator_id', 'created_at']);
            $table->index('is_approved');
            $table->index('is_posted');
            $table->index('is_favorite');
            $table->index('confidence_score');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('auto_reply_suggestions');
    }
};