<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('social_comments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('social_post_id');
            $table->unsignedBigInteger('social_account_id');
            $table->unsignedBigInteger('brand_id')->nullable();
            $table->unsignedBigInteger('creator_id')->nullable();
            $table->string('provider_comment_id')->unique();
            $table->text('content');
            $table->string('author_name');
            $table->string('author_username')->nullable();
            $table->string('author_avatar_url')->nullable();
            $table->boolean('is_reply')->default(false);
            $table->unsignedBigInteger('parent_id')->nullable();
            $table->json('raw_data')->nullable();
            $table->timestamp('published_at');
            $table->timestamp('last_checked_at')->nullable();
            $table->timestamps();
            
            $table->foreign('social_post_id')->references('id')->on('social_posts')->onDelete('cascade');
            $table->foreign('social_account_id')->references('id')->on('social_accounts')->onDelete('cascade');
            $table->foreign('brand_id')->references('id')->on('brands')->onDelete('cascade');
            $table->foreign('creator_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('parent_id')->references('id')->on('social_comments')->onDelete('cascade');
            
            $table->index(['social_post_id', 'published_at']);
            $table->index(['social_account_id', 'published_at']);
            $table->index(['brand_id', 'published_at']);
            $table->index(['creator_id', 'published_at']);
            $table->index('provider_comment_id');
            $table->index('is_reply');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('social_comments');
    }
};