<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('proposals', function (Blueprint $table) {
            if (!Schema::hasColumn('proposals', 'contract_id')) {
                $table->unsignedBigInteger('contract_id')->nullable()->after('status');
                $table->foreign('contract_id')->references('id')->on('contracts')->onDelete('set null');
                $table->index('contract_id');
            }
            
            if (!Schema::hasColumn('proposals', 'payment_id')) {
                $table->unsignedBigInteger('payment_id')->nullable()->after('contract_id');
                $table->foreign('payment_id')->references('id')->on('payments')->onDelete('set null');
                $table->index('payment_id');
            }
            
            if (!Schema::hasColumn('proposals', 'expires_at')) {
                $table->timestamp('expires_at')->nullable()->after('read_at');
            }
            
            if (!Schema::hasColumn('proposals', 'response_deadline')) {
                $table->timestamp('response_deadline')->nullable()->after('expires_at');
            }
            
            if (!Schema::hasColumn('proposals', 'terms')) {
                $table->text('terms')->nullable()->after('response_deadline');
            }
            
            if (!Schema::hasColumn('proposals', 'signed_at')) {
                $table->timestamp('signed_at')->nullable()->after('terms');
            }
            
            if (!Schema::hasColumn('proposals', 'delivered_at')) {
                $table->timestamp('delivered_at')->nullable()->after('signed_at');
            }
            
            if (!Schema::hasColumn('proposals', 'delivery_notes')) {
                $table->text('delivery_notes')->nullable()->after('delivered_at');
            }
            
            if (!Schema::hasColumn('proposals', 'rating')) {
                $table->decimal('rating', 3, 2)->nullable()->after('delivery_notes');
            }
            
            if (!Schema::hasColumn('proposals', 'review')) {
                $table->text('review')->nullable()->after('rating');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('proposals', function (Blueprint $table) {
            if (Schema::hasColumn('proposals', 'contract_id')) {
                $table->dropForeign(['contract_id']);
                $table->dropColumn('contract_id');
            }
            
            if (Schema::hasColumn('proposals', 'payment_id')) {
                $table->dropForeign(['payment_id']);
                $table->dropColumn('payment_id');
            }
            
            if (Schema::hasColumn('proposals', 'expires_at')) {
                $table->dropColumn('expires_at');
            }
            
            if (Schema::hasColumn('proposals', 'response_deadline')) {
                $table->dropColumn('response_deadline');
            }
            
            if (Schema::hasColumn('proposals', 'terms')) {
                $table->dropColumn('terms');
            }
            
            if (Schema::hasColumn('proposals', 'signed_at')) {
                $table->dropColumn('signed_at');
            }
            
            if (Schema::hasColumn('proposals', 'delivered_at')) {
                $table->dropColumn('delivered_at');
            }
            
            if (Schema::hasColumn('proposals', 'delivery_notes')) {
                $table->dropColumn('delivery_notes');
            }
            
            if (Schema::hasColumn('proposals', 'rating')) {
                $table->dropColumn('rating');
            }
            
            if (Schema::hasColumn('proposals', 'review')) {
                $table->dropColumn('review');
            }
        });
    }
};
