<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('campaign_creators', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('campaign_id');
            $table->unsignedBigInteger('creator_id');
            $table->unsignedBigInteger('invited_by');
            $table->string('invitation_token')->nullable();
            $table->enum('status', ['invited', 'accepted', 'declined', 'proposal_sent', 'proposal_accepted', 'proposal_rejected'])->default('invited');
            $table->timestamp('invitation_sent_at')->nullable();
            $table->timestamp('responded_at')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
            
            // Foreign key constraints
            $table->foreign('campaign_id')->references('id')->on('campaigns')->onDelete('cascade');
            $table->foreign('creator_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('invited_by')->references('id')->on('users')->onDelete('cascade');
            
            // Unique constraint to prevent duplicate entries
            $table->unique(['campaign_id', 'creator_id'], 'unique_campaign_creator');
            
            // Indexes for better performance
            $table->index('campaign_id');
            $table->index('creator_id');
            $table->index('invited_by');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('campaign_creators');
    }
};
