<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('marketplace_shortlist_creators', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('shortlist_id');
            $table->unsignedBigInteger('creator_id');
            $table->unsignedBigInteger('added_by');
            $table->text('notes')->nullable();
            $table->timestamps();
            
            // Foreign key constraints
            $table->foreign('shortlist_id')->references('id')->on('marketplace_shortlists')->onDelete('cascade');
            $table->foreign('creator_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('added_by')->references('id')->on('users')->onDelete('cascade');
            
            // Unique constraint to prevent duplicate entries
            $table->unique(['shortlist_id', 'creator_id'], 'unique_shortlist_creator');
            
            // Indexes for better performance
            $table->index('shortlist_id');
            $table->index('creator_id');
            $table->index('added_by');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('marketplace_shortlist_creators');
    }
};
