<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scheduled_reels', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('owner_id');
            $table->string('owner_type');
            $table->unsignedBigInteger('poster_id')->nullable();
            $table->string('template');
            $table->json('options')->nullable();
            $table->json('source_inputs')->nullable();
            $table->timestamp('scheduled_at')->nullable();
            $table->string('timezone')->nullable();
            $table->string('status')->default('draft');
            $table->string('processor_job_id')->nullable();
            $table->json('result_paths')->nullable();
            $table->integer('attempt_count')->default(0);
            $table->text('error_message')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
            
            $table->index(['scheduled_at', 'status']);
            $table->index(['owner_id', 'owner_type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scheduled_reels');
    }
};